package tecgraf.openbus.data_service.sharedobjects.v1_00;

import java.nio.charset.Charset;

import tecgraf.openbus.data_service.sharedobjects.v1_00.SharedObjectDataView;
import tecgraf.openbus.data_service.sharedobjects.v1_00.SharedObjectDataViewHelper;

/**
 * Classe que implementa o dataview de shared object
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class SharedObjectDataViewImpl extends SharedObjectDataView {

  /** charset default é UTF-8 */
  private static final Charset STANDARD_SHARED_OBJECT_CHAR_SET = Charset
    .forName("UTF-8");

  /**
   * Construtor de {@link SharedObjectDataView} para ser usado quando o ORB
   * desserializa o dado recebido na requisição e injeta o conteúdo no objeto da
   * aplicação. Esse construtor não será usado diretamente pelo programador da
   * aplicação, será útil para a fábrica de valuetypes
   * {@link SharedObjectDataViewFactory}.
   */
  public SharedObjectDataViewImpl() {
    super();
  }

  /**
   * Construtor de {@link SharedObjectDataView} para o provedor da informação
   * preencher o conteúdo a partir de um arquivo. Esse construtor será
   * tipicamente útil para o lado servidor.
   * 
   * @param fKey chave do shared object
   * @param contents conteúdo do sharedobject
   */
  public SharedObjectDataViewImpl(byte[] fKey, String contents) {
    super();
    this.fKey = fKey;
    this.contents = contents.getBytes(STANDARD_SHARED_OBJECT_CHAR_SET);
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  public byte[] getKey() {
    return this.fKey;
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  public String getInterfaceName() {
    return SharedObjectDataViewHelper.id();
  }

}
