package br.pucrio.tecgraf.soma.job.domain.model;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;

/**
 * Job Algorithm Parameter Entity
 */
@Entity
@Table(name="job_algo_params")
public class JobAlgorithmParameter {

    // Identifier
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;

    // The parameter identifier
    @Column(name="param_id", nullable=false)
    private String parameterId;

    // Parameter label
    @Column(name="param_label", nullable=false)
    private String label;

    // The type of the parameter
    @Column(name="param_type", nullable=false)
    private String type;

    @ManyToOne
    @JoinColumn(name="job_algo_id", nullable=false)
    private JobAlgorithm jobAlgorithm;

    // The list of values submitted in the parameter
    @ElementCollection
    @CollectionTable(
            name="job_param_values",
            joinColumns=@JoinColumn(name="job_algo_param_id")
    )
    @Column(length=10000)
    private List<String> value = new ArrayList<String>();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getParameterId() {
        return parameterId;
    }

    public void setParameterId(String parameterId) {
        this.parameterId = parameterId;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public JobAlgorithm getJobAlgorithm() {
        return jobAlgorithm;
    }

    public void setJobAlgorithm(JobAlgorithm jobAlgorithm) {
        this.jobAlgorithm = jobAlgorithm;
    }

    public List<String> getValue() {
        return value;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }
}
