package br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl;

import com.github.tennaito.rsql.builder.BuilderTools;
import com.github.tennaito.rsql.jpa.JpaPredicateVisitor;
import com.github.tennaito.rsql.misc.Mapper;

import javax.persistence.EntityManager;

import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import cz.jirutka.rsql.parser.RSQLParser;

public class RSQLSpecFactory<T> {
  private final RSQLParser parser = new RSQLParser();
  private final JpaPredicateVisitor<T> visitor;
  private final EntityManager entityManager;

  public RSQLSpecFactory(EntityManager entityManager) {
    this(entityManager, null);
  }

  public RSQLSpecFactory(EntityManager entityManager, Mapper mapper) {
    this.visitor = new JpaPredicateVisitor<>();
    this.entityManager = entityManager;

    BuilderTools builder = visitor.getBuilderTools();
    builder.setArgumentParser(new RSQLArgumentParser());
    if (mapper != null) {
      builder.setPropertiesMapper(mapper);
    }
  }

  public JPASpecification<T> create(String rsql) {
    return new RSQLSpecification<>(parser.parse(rsql), visitor, entityManager);
  }
}
