package br.pucrio.tecgraf.soma.job.application.service.job.builder;

import br.pucrio.tecgraf.soma.job.JobStageOutEvent;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper.StageOutJobMapper;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobStatusHistory;
import br.pucrio.tecgraf.soma.job.domain.model.StatusType;

public class StageOutJobBuilder extends AbstractJobBuilder {

  public void build(Job job, JobStageOutEvent event) {
    StageOutJobMapper.getInstance().map(event, job);

    JobStatusHistory jobStatusHistory =
        newJobStatusHistory(StatusType.DOWNLOADING, event.getTimestamp());
    job.addStatusHistory(jobStatusHistory);
  }
}
