package br.pucrio.tecgraf.soma.job.application.configuration;

import br.pucrio.tecgraf.soma.serviceapi.ServiceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

import javax.persistence.EntityManagerFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

@Configuration
public class SomaJobHistoryConsumerConfiguration {

  private final Logger logger = LoggerFactory.getLogger(SomaJobHistoryConsumerConfiguration.class);

  @Bean
  public ServiceContext serviceContext(
      @Value("${hibernate-config}") String hibernateConfiguration) {
    // Injeta o valor do argumento "hibernate-config" da linha de comando
    Properties properties = null;
    if (hibernateConfiguration != null) {
      properties = new Properties();
      try {
        properties.load(new StringReader(hibernateConfiguration.replaceAll(",", "\n")));
      } catch (IOException e) {
        logger.error("Error reading Hibernate configuration from arguments.", e);
      }
    }
    return new ServiceContext(
        properties, "hibernate.cfg.xml", "br.pucrio.tecgraf.soma.job.domain.model");
  }

  @Bean
  public EntityManagerFactory entityManagerFactory(ServiceContext serviceContext) {
    return serviceContext.getEntityManagerFactory();
  }

  @Bean
  public PlatformTransactionManager transactionManager(EntityManagerFactory emf) {
    JpaTransactionManager transactionManager = new JpaTransactionManager();
    transactionManager.setEntityManagerFactory(emf);

    return transactionManager;
  }
}
