/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.configuration;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class SocketHandler
extends TextWebSocketHandler {
    List<WebSocketSession> sessions = new CopyOnWriteArrayList();

    public void handleTextMessage(WebSocketSession session, TextMessage message) throws InterruptedException, IOException {
        for (WebSocketSession webSocketSession : this.sessions) {
            if (webSocketSession.isOpen()) {
                webSocketSession.sendMessage((WebSocketMessage)message);
                continue;
            }
            this.sessions.remove(webSocketSession);
        }
    }

    public void sendMessage(String json_message) throws IOException, InterruptedException {
        this.handleTextMessage(null, new TextMessage((CharSequence)json_message));
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        this.sessions.add(session);
    }
}

