/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */
package br.pucrio.tecgraf.soma.job;

import org.apache.avro.specific.SpecificData;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.SchemaStore;

@SuppressWarnings("all")
/** Avro Schema for the event of job scheduled. All the information came from the job submission. */
@org.apache.avro.specific.AvroGenerated
public class JobScheduledEvent extends org.apache.avro.specific.SpecificRecordBase implements org.apache.avro.specific.SpecificRecord {
  private static final long serialVersionUID = -7685401813133355866L;
  public static final org.apache.avro.Schema SCHEMA$ = new org.apache.avro.Schema.Parser().parse("{\"type\":\"record\",\"name\":\"JobScheduledEvent\",\"namespace\":\"br.pucrio.tecgraf.soma.job\",\"doc\":\"Avro Schema for the event of job scheduled. All the information came from the job submission.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"groupId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Job group identifier\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"},{\"name\":\"owner\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Owner's user identifier\",\"default\":\"\"},{\"name\":\"automaticallyMachineSelection\",\"type\":\"boolean\",\"doc\":\"Flag to indicate option for automatically machine selection\",\"default\":false},{\"name\":\"selectedMachines\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Machines that user selected for execution.\",\"default\":[]},{\"name\":\"dependencyIds\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Array of job ids that need to successfully finish for this one to run.\",\"default\":[]},{\"name\":\"numberOfProcesses\",\"type\":\"int\",\"doc\":\"The total number of processes. In the case of multiple execution, this number can be more than one.\",\"default\":1},{\"name\":\"numberOfProcessesByMachine\",\"type\":\"int\",\"doc\":\"The number of processes by machine. In the case of multiple execution, this number can be more than one.\",\"default\":1},{\"name\":\"submissionTime\",\"type\":\"long\",\"doc\":\"The timestamp of job submission.\",\"default\":0},{\"name\":\"description\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job description.\",\"default\":\"\"},{\"name\":\"priority\",\"type\":\"int\",\"doc\":\"Execution priority.\",\"default\":0},{\"name\":\"multipleExecution\",\"type\":\"boolean\",\"doc\":\"If the submission will create multiple jobs.\",\"default\":false},{\"name\":\"specificationType\",\"type\":{\"type\":\"enum\",\"name\":\"SpecificationType\",\"symbols\":[\"ALGORITHM\",\"FLOW\"]},\"default\":\"ALGORITHM\"},{\"name\":\"specification\",\"type\":[{\"type\":\"record\",\"name\":\"Algorithm\",\"doc\":\"Avro Schema for algorithm parameters.\",\"fields\":[{\"name\":\"algorithmId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The algorithm identifier.\",\"default\":\"\"},{\"name\":\"algorithmVersion\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The algorithm version.\",\"default\":\"\"},{\"name\":\"algorithmName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The algorithm name.\",\"default\":\"\"},{\"name\":\"parameters\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"AlgorithmParameter\",\"doc\":\"Avro Schema for algorithm parameter.\",\"fields\":[{\"name\":\"parameterId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The parameter identifier.\",\"default\":\"\"},{\"name\":\"label\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The parameter label.\",\"default\":\"\"},{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The parameter type.\",\"default\":\"\"},{\"name\":\"value\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The parameter value.\",\"default\":\"null\"}],\"version\":\"1\"}},\"doc\":\"The algorithm parameters.\",\"default\":[]},{\"name\":\"flowNodeId\",\"type\":\"int\",\"doc\":\"The flow node id (it helps to identify same algorithms inside a flow)\",\"default\":0}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"Flow\",\"fields\":[{\"name\":\"flowId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The flow identifier.\",\"default\":\"\"},{\"name\":\"flowVersion\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The flow version.\",\"default\":\"\"},{\"name\":\"flowName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The flow name.\",\"default\":\"\"},{\"name\":\"raw\",\"type\":\"bytes\",\"doc\":\"The flow raw configurator.\",\"default\":\"\"},{\"name\":\"algorithms\",\"type\":{\"type\":\"array\",\"items\":\"Algorithm\"},\"doc\":\"The parameters for each algorithm in the flow.\",\"default\":[]}],\"version\":\"1\"}],\"doc\":\"If the job is related to an algorithm or to a flow.\",\"default\":\"br.pucrio.tecgraf.soma.job.Algorithm\"}],\"version\":\"1\"}");
  public static org.apache.avro.Schema getClassSchema() { return SCHEMA$; }

  private static SpecificData MODEL$ = new SpecificData();

  private static final BinaryMessageEncoder<JobScheduledEvent> ENCODER =
      new BinaryMessageEncoder<JobScheduledEvent>(MODEL$, SCHEMA$);

  private static final BinaryMessageDecoder<JobScheduledEvent> DECODER =
      new BinaryMessageDecoder<JobScheduledEvent>(MODEL$, SCHEMA$);

  /**
   * Return the BinaryMessageDecoder instance used by this class.
   */
  public static BinaryMessageDecoder<JobScheduledEvent> getDecoder() {
    return DECODER;
  }

  /**
   * Create a new BinaryMessageDecoder instance for this class that uses the specified {@link SchemaStore}.
   * @param resolver a {@link SchemaStore} used to find schemas by fingerprint
   */
  public static BinaryMessageDecoder<JobScheduledEvent> createDecoder(SchemaStore resolver) {
    return new BinaryMessageDecoder<JobScheduledEvent>(MODEL$, SCHEMA$, resolver);
  }

  /** Serializes this JobScheduledEvent to a ByteBuffer. */
  public java.nio.ByteBuffer toByteBuffer() throws java.io.IOException {
    return ENCODER.encode(this);
  }

  /** Deserializes a JobScheduledEvent from a ByteBuffer. */
  public static JobScheduledEvent fromByteBuffer(
      java.nio.ByteBuffer b) throws java.io.IOException {
    return DECODER.decode(b);
  }

  /** The job event identifier */
  @Deprecated public java.lang.String eventId;
  /** The job event timestamp */
  @Deprecated public long timestamp;
  /** The identification of the job */
  @Deprecated public java.lang.String jobId;
  /** Job group identifier */
  @Deprecated public java.lang.String groupId;
  /** Project identifier */
  @Deprecated public java.lang.String projectId;
  /** Owner's user identifier */
  @Deprecated public java.lang.String owner;
  /** Flag to indicate option for automatically machine selection */
  @Deprecated public boolean automaticallyMachineSelection;
  /** Machines that user selected for execution. */
  @Deprecated public java.util.List<java.lang.String> selectedMachines;
  /** Array of job ids that need to successfully finish for this one to run. */
  @Deprecated public java.util.List<java.lang.String> dependencyIds;
  /** The total number of processes. In the case of multiple execution, this number can be more than one. */
  @Deprecated public int numberOfProcesses;
  /** The number of processes by machine. In the case of multiple execution, this number can be more than one. */
  @Deprecated public int numberOfProcessesByMachine;
  /** The timestamp of job submission. */
  @Deprecated public long submissionTime;
  /** The job description. */
  @Deprecated public java.lang.String description;
  /** Execution priority. */
  @Deprecated public int priority;
  /** If the submission will create multiple jobs. */
  @Deprecated public boolean multipleExecution;
  @Deprecated public br.pucrio.tecgraf.soma.job.SpecificationType specificationType;
  /** If the job is related to an algorithm or to a flow. */
  @Deprecated public java.lang.Object specification;

  /**
   * Default constructor.  Note that this does not initialize fields
   * to their default values from the schema.  If that is desired then
   * one should use <code>newBuilder()</code>.
   */
  public JobScheduledEvent() {}

  /**
   * All-args constructor.
   * @param eventId The job event identifier
   * @param timestamp The job event timestamp
   * @param jobId The identification of the job
   * @param groupId Job group identifier
   * @param projectId Project identifier
   * @param owner Owner's user identifier
   * @param automaticallyMachineSelection Flag to indicate option for automatically machine selection
   * @param selectedMachines Machines that user selected for execution.
   * @param dependencyIds Array of job ids that need to successfully finish for this one to run.
   * @param numberOfProcesses The total number of processes. In the case of multiple execution, this number can be more than one.
   * @param numberOfProcessesByMachine The number of processes by machine. In the case of multiple execution, this number can be more than one.
   * @param submissionTime The timestamp of job submission.
   * @param description The job description.
   * @param priority Execution priority.
   * @param multipleExecution If the submission will create multiple jobs.
   * @param specificationType The new value for specificationType
   * @param specification If the job is related to an algorithm or to a flow.
   */
  public JobScheduledEvent(java.lang.String eventId, java.lang.Long timestamp, java.lang.String jobId, java.lang.String groupId, java.lang.String projectId, java.lang.String owner, java.lang.Boolean automaticallyMachineSelection, java.util.List<java.lang.String> selectedMachines, java.util.List<java.lang.String> dependencyIds, java.lang.Integer numberOfProcesses, java.lang.Integer numberOfProcessesByMachine, java.lang.Long submissionTime, java.lang.String description, java.lang.Integer priority, java.lang.Boolean multipleExecution, br.pucrio.tecgraf.soma.job.SpecificationType specificationType, java.lang.Object specification) {
    this.eventId = eventId;
    this.timestamp = timestamp;
    this.jobId = jobId;
    this.groupId = groupId;
    this.projectId = projectId;
    this.owner = owner;
    this.automaticallyMachineSelection = automaticallyMachineSelection;
    this.selectedMachines = selectedMachines;
    this.dependencyIds = dependencyIds;
    this.numberOfProcesses = numberOfProcesses;
    this.numberOfProcessesByMachine = numberOfProcessesByMachine;
    this.submissionTime = submissionTime;
    this.description = description;
    this.priority = priority;
    this.multipleExecution = multipleExecution;
    this.specificationType = specificationType;
    this.specification = specification;
  }

  public org.apache.avro.Schema getSchema() { return SCHEMA$; }
  // Used by DatumWriter.  Applications should not call.
  public java.lang.Object get(int field$) {
    switch (field$) {
    case 0: return eventId;
    case 1: return timestamp;
    case 2: return jobId;
    case 3: return groupId;
    case 4: return projectId;
    case 5: return owner;
    case 6: return automaticallyMachineSelection;
    case 7: return selectedMachines;
    case 8: return dependencyIds;
    case 9: return numberOfProcesses;
    case 10: return numberOfProcessesByMachine;
    case 11: return submissionTime;
    case 12: return description;
    case 13: return priority;
    case 14: return multipleExecution;
    case 15: return specificationType;
    case 16: return specification;
    default: throw new org.apache.avro.AvroRuntimeException("Bad index");
    }
  }

  // Used by DatumReader.  Applications should not call.
  @SuppressWarnings(value="unchecked")
  public void put(int field$, java.lang.Object value$) {
    switch (field$) {
    case 0: eventId = (java.lang.String)value$; break;
    case 1: timestamp = (java.lang.Long)value$; break;
    case 2: jobId = (java.lang.String)value$; break;
    case 3: groupId = (java.lang.String)value$; break;
    case 4: projectId = (java.lang.String)value$; break;
    case 5: owner = (java.lang.String)value$; break;
    case 6: automaticallyMachineSelection = (java.lang.Boolean)value$; break;
    case 7: selectedMachines = (java.util.List<java.lang.String>)value$; break;
    case 8: dependencyIds = (java.util.List<java.lang.String>)value$; break;
    case 9: numberOfProcesses = (java.lang.Integer)value$; break;
    case 10: numberOfProcessesByMachine = (java.lang.Integer)value$; break;
    case 11: submissionTime = (java.lang.Long)value$; break;
    case 12: description = (java.lang.String)value$; break;
    case 13: priority = (java.lang.Integer)value$; break;
    case 14: multipleExecution = (java.lang.Boolean)value$; break;
    case 15: specificationType = (br.pucrio.tecgraf.soma.job.SpecificationType)value$; break;
    case 16: specification = (java.lang.Object)value$; break;
    default: throw new org.apache.avro.AvroRuntimeException("Bad index");
    }
  }

  /**
   * Gets the value of the 'eventId' field.
   * @return The job event identifier
   */
  public java.lang.String getEventId() {
    return eventId;
  }

  /**
   * Sets the value of the 'eventId' field.
   * The job event identifier
   * @param value the value to set.
   */
  public void setEventId(java.lang.String value) {
    this.eventId = value;
  }

  /**
   * Gets the value of the 'timestamp' field.
   * @return The job event timestamp
   */
  public java.lang.Long getTimestamp() {
    return timestamp;
  }

  /**
   * Sets the value of the 'timestamp' field.
   * The job event timestamp
   * @param value the value to set.
   */
  public void setTimestamp(java.lang.Long value) {
    this.timestamp = value;
  }

  /**
   * Gets the value of the 'jobId' field.
   * @return The identification of the job
   */
  public java.lang.String getJobId() {
    return jobId;
  }

  /**
   * Sets the value of the 'jobId' field.
   * The identification of the job
   * @param value the value to set.
   */
  public void setJobId(java.lang.String value) {
    this.jobId = value;
  }

  /**
   * Gets the value of the 'groupId' field.
   * @return Job group identifier
   */
  public java.lang.String getGroupId() {
    return groupId;
  }

  /**
   * Sets the value of the 'groupId' field.
   * Job group identifier
   * @param value the value to set.
   */
  public void setGroupId(java.lang.String value) {
    this.groupId = value;
  }

  /**
   * Gets the value of the 'projectId' field.
   * @return Project identifier
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * Sets the value of the 'projectId' field.
   * Project identifier
   * @param value the value to set.
   */
  public void setProjectId(java.lang.String value) {
    this.projectId = value;
  }

  /**
   * Gets the value of the 'owner' field.
   * @return Owner's user identifier
   */
  public java.lang.String getOwner() {
    return owner;
  }

  /**
   * Sets the value of the 'owner' field.
   * Owner's user identifier
   * @param value the value to set.
   */
  public void setOwner(java.lang.String value) {
    this.owner = value;
  }

  /**
   * Gets the value of the 'automaticallyMachineSelection' field.
   * @return Flag to indicate option for automatically machine selection
   */
  public java.lang.Boolean getAutomaticallyMachineSelection() {
    return automaticallyMachineSelection;
  }

  /**
   * Sets the value of the 'automaticallyMachineSelection' field.
   * Flag to indicate option for automatically machine selection
   * @param value the value to set.
   */
  public void setAutomaticallyMachineSelection(java.lang.Boolean value) {
    this.automaticallyMachineSelection = value;
  }

  /**
   * Gets the value of the 'selectedMachines' field.
   * @return Machines that user selected for execution.
   */
  public java.util.List<java.lang.String> getSelectedMachines() {
    return selectedMachines;
  }

  /**
   * Sets the value of the 'selectedMachines' field.
   * Machines that user selected for execution.
   * @param value the value to set.
   */
  public void setSelectedMachines(java.util.List<java.lang.String> value) {
    this.selectedMachines = value;
  }

  /**
   * Gets the value of the 'dependencyIds' field.
   * @return Array of job ids that need to successfully finish for this one to run.
   */
  public java.util.List<java.lang.String> getDependencyIds() {
    return dependencyIds;
  }

  /**
   * Sets the value of the 'dependencyIds' field.
   * Array of job ids that need to successfully finish for this one to run.
   * @param value the value to set.
   */
  public void setDependencyIds(java.util.List<java.lang.String> value) {
    this.dependencyIds = value;
  }

  /**
   * Gets the value of the 'numberOfProcesses' field.
   * @return The total number of processes. In the case of multiple execution, this number can be more than one.
   */
  public java.lang.Integer getNumberOfProcesses() {
    return numberOfProcesses;
  }

  /**
   * Sets the value of the 'numberOfProcesses' field.
   * The total number of processes. In the case of multiple execution, this number can be more than one.
   * @param value the value to set.
   */
  public void setNumberOfProcesses(java.lang.Integer value) {
    this.numberOfProcesses = value;
  }

  /**
   * Gets the value of the 'numberOfProcessesByMachine' field.
   * @return The number of processes by machine. In the case of multiple execution, this number can be more than one.
   */
  public java.lang.Integer getNumberOfProcessesByMachine() {
    return numberOfProcessesByMachine;
  }

  /**
   * Sets the value of the 'numberOfProcessesByMachine' field.
   * The number of processes by machine. In the case of multiple execution, this number can be more than one.
   * @param value the value to set.
   */
  public void setNumberOfProcessesByMachine(java.lang.Integer value) {
    this.numberOfProcessesByMachine = value;
  }

  /**
   * Gets the value of the 'submissionTime' field.
   * @return The timestamp of job submission.
   */
  public java.lang.Long getSubmissionTime() {
    return submissionTime;
  }

  /**
   * Sets the value of the 'submissionTime' field.
   * The timestamp of job submission.
   * @param value the value to set.
   */
  public void setSubmissionTime(java.lang.Long value) {
    this.submissionTime = value;
  }

  /**
   * Gets the value of the 'description' field.
   * @return The job description.
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Sets the value of the 'description' field.
   * The job description.
   * @param value the value to set.
   */
  public void setDescription(java.lang.String value) {
    this.description = value;
  }

  /**
   * Gets the value of the 'priority' field.
   * @return Execution priority.
   */
  public java.lang.Integer getPriority() {
    return priority;
  }

  /**
   * Sets the value of the 'priority' field.
   * Execution priority.
   * @param value the value to set.
   */
  public void setPriority(java.lang.Integer value) {
    this.priority = value;
  }

  /**
   * Gets the value of the 'multipleExecution' field.
   * @return If the submission will create multiple jobs.
   */
  public java.lang.Boolean getMultipleExecution() {
    return multipleExecution;
  }

  /**
   * Sets the value of the 'multipleExecution' field.
   * If the submission will create multiple jobs.
   * @param value the value to set.
   */
  public void setMultipleExecution(java.lang.Boolean value) {
    this.multipleExecution = value;
  }

  /**
   * Gets the value of the 'specificationType' field.
   * @return The value of the 'specificationType' field.
   */
  public br.pucrio.tecgraf.soma.job.SpecificationType getSpecificationType() {
    return specificationType;
  }

  /**
   * Sets the value of the 'specificationType' field.
   * @param value the value to set.
   */
  public void setSpecificationType(br.pucrio.tecgraf.soma.job.SpecificationType value) {
    this.specificationType = value;
  }

  /**
   * Gets the value of the 'specification' field.
   * @return If the job is related to an algorithm or to a flow.
   */
  public java.lang.Object getSpecification() {
    return specification;
  }

  /**
   * Sets the value of the 'specification' field.
   * If the job is related to an algorithm or to a flow.
   * @param value the value to set.
   */
  public void setSpecification(java.lang.Object value) {
    this.specification = value;
  }

  /**
   * Creates a new JobScheduledEvent RecordBuilder.
   * @return A new JobScheduledEvent RecordBuilder
   */
  public static br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder newBuilder() {
    return new br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder();
  }

  /**
   * Creates a new JobScheduledEvent RecordBuilder by copying an existing Builder.
   * @param other The existing builder to copy.
   * @return A new JobScheduledEvent RecordBuilder
   */
  public static br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder newBuilder(br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder other) {
    return new br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder(other);
  }

  /**
   * Creates a new JobScheduledEvent RecordBuilder by copying an existing JobScheduledEvent instance.
   * @param other The existing instance to copy.
   * @return A new JobScheduledEvent RecordBuilder
   */
  public static br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder newBuilder(br.pucrio.tecgraf.soma.job.JobScheduledEvent other) {
    return new br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder(other);
  }

  /**
   * RecordBuilder for JobScheduledEvent instances.
   */
  public static class Builder extends org.apache.avro.specific.SpecificRecordBuilderBase<JobScheduledEvent>
    implements org.apache.avro.data.RecordBuilder<JobScheduledEvent> {

    /** The job event identifier */
    private java.lang.String eventId;
    /** The job event timestamp */
    private long timestamp;
    /** The identification of the job */
    private java.lang.String jobId;
    /** Job group identifier */
    private java.lang.String groupId;
    /** Project identifier */
    private java.lang.String projectId;
    /** Owner's user identifier */
    private java.lang.String owner;
    /** Flag to indicate option for automatically machine selection */
    private boolean automaticallyMachineSelection;
    /** Machines that user selected for execution. */
    private java.util.List<java.lang.String> selectedMachines;
    /** Array of job ids that need to successfully finish for this one to run. */
    private java.util.List<java.lang.String> dependencyIds;
    /** The total number of processes. In the case of multiple execution, this number can be more than one. */
    private int numberOfProcesses;
    /** The number of processes by machine. In the case of multiple execution, this number can be more than one. */
    private int numberOfProcessesByMachine;
    /** The timestamp of job submission. */
    private long submissionTime;
    /** The job description. */
    private java.lang.String description;
    /** Execution priority. */
    private int priority;
    /** If the submission will create multiple jobs. */
    private boolean multipleExecution;
    private br.pucrio.tecgraf.soma.job.SpecificationType specificationType;
    /** If the job is related to an algorithm or to a flow. */
    private java.lang.Object specification;

    /** Creates a new Builder */
    private Builder() {
      super(SCHEMA$);
    }

    /**
     * Creates a Builder by copying an existing Builder.
     * @param other The existing Builder to copy.
     */
    private Builder(br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder other) {
      super(other);
      if (isValidValue(fields()[0], other.eventId)) {
        this.eventId = data().deepCopy(fields()[0].schema(), other.eventId);
        fieldSetFlags()[0] = true;
      }
      if (isValidValue(fields()[1], other.timestamp)) {
        this.timestamp = data().deepCopy(fields()[1].schema(), other.timestamp);
        fieldSetFlags()[1] = true;
      }
      if (isValidValue(fields()[2], other.jobId)) {
        this.jobId = data().deepCopy(fields()[2].schema(), other.jobId);
        fieldSetFlags()[2] = true;
      }
      if (isValidValue(fields()[3], other.groupId)) {
        this.groupId = data().deepCopy(fields()[3].schema(), other.groupId);
        fieldSetFlags()[3] = true;
      }
      if (isValidValue(fields()[4], other.projectId)) {
        this.projectId = data().deepCopy(fields()[4].schema(), other.projectId);
        fieldSetFlags()[4] = true;
      }
      if (isValidValue(fields()[5], other.owner)) {
        this.owner = data().deepCopy(fields()[5].schema(), other.owner);
        fieldSetFlags()[5] = true;
      }
      if (isValidValue(fields()[6], other.automaticallyMachineSelection)) {
        this.automaticallyMachineSelection = data().deepCopy(fields()[6].schema(), other.automaticallyMachineSelection);
        fieldSetFlags()[6] = true;
      }
      if (isValidValue(fields()[7], other.selectedMachines)) {
        this.selectedMachines = data().deepCopy(fields()[7].schema(), other.selectedMachines);
        fieldSetFlags()[7] = true;
      }
      if (isValidValue(fields()[8], other.dependencyIds)) {
        this.dependencyIds = data().deepCopy(fields()[8].schema(), other.dependencyIds);
        fieldSetFlags()[8] = true;
      }
      if (isValidValue(fields()[9], other.numberOfProcesses)) {
        this.numberOfProcesses = data().deepCopy(fields()[9].schema(), other.numberOfProcesses);
        fieldSetFlags()[9] = true;
      }
      if (isValidValue(fields()[10], other.numberOfProcessesByMachine)) {
        this.numberOfProcessesByMachine = data().deepCopy(fields()[10].schema(), other.numberOfProcessesByMachine);
        fieldSetFlags()[10] = true;
      }
      if (isValidValue(fields()[11], other.submissionTime)) {
        this.submissionTime = data().deepCopy(fields()[11].schema(), other.submissionTime);
        fieldSetFlags()[11] = true;
      }
      if (isValidValue(fields()[12], other.description)) {
        this.description = data().deepCopy(fields()[12].schema(), other.description);
        fieldSetFlags()[12] = true;
      }
      if (isValidValue(fields()[13], other.priority)) {
        this.priority = data().deepCopy(fields()[13].schema(), other.priority);
        fieldSetFlags()[13] = true;
      }
      if (isValidValue(fields()[14], other.multipleExecution)) {
        this.multipleExecution = data().deepCopy(fields()[14].schema(), other.multipleExecution);
        fieldSetFlags()[14] = true;
      }
      if (isValidValue(fields()[15], other.specificationType)) {
        this.specificationType = data().deepCopy(fields()[15].schema(), other.specificationType);
        fieldSetFlags()[15] = true;
      }
      if (isValidValue(fields()[16], other.specification)) {
        this.specification = data().deepCopy(fields()[16].schema(), other.specification);
        fieldSetFlags()[16] = true;
      }
    }

    /**
     * Creates a Builder by copying an existing JobScheduledEvent instance
     * @param other The existing instance to copy.
     */
    private Builder(br.pucrio.tecgraf.soma.job.JobScheduledEvent other) {
            super(SCHEMA$);
      if (isValidValue(fields()[0], other.eventId)) {
        this.eventId = data().deepCopy(fields()[0].schema(), other.eventId);
        fieldSetFlags()[0] = true;
      }
      if (isValidValue(fields()[1], other.timestamp)) {
        this.timestamp = data().deepCopy(fields()[1].schema(), other.timestamp);
        fieldSetFlags()[1] = true;
      }
      if (isValidValue(fields()[2], other.jobId)) {
        this.jobId = data().deepCopy(fields()[2].schema(), other.jobId);
        fieldSetFlags()[2] = true;
      }
      if (isValidValue(fields()[3], other.groupId)) {
        this.groupId = data().deepCopy(fields()[3].schema(), other.groupId);
        fieldSetFlags()[3] = true;
      }
      if (isValidValue(fields()[4], other.projectId)) {
        this.projectId = data().deepCopy(fields()[4].schema(), other.projectId);
        fieldSetFlags()[4] = true;
      }
      if (isValidValue(fields()[5], other.owner)) {
        this.owner = data().deepCopy(fields()[5].schema(), other.owner);
        fieldSetFlags()[5] = true;
      }
      if (isValidValue(fields()[6], other.automaticallyMachineSelection)) {
        this.automaticallyMachineSelection = data().deepCopy(fields()[6].schema(), other.automaticallyMachineSelection);
        fieldSetFlags()[6] = true;
      }
      if (isValidValue(fields()[7], other.selectedMachines)) {
        this.selectedMachines = data().deepCopy(fields()[7].schema(), other.selectedMachines);
        fieldSetFlags()[7] = true;
      }
      if (isValidValue(fields()[8], other.dependencyIds)) {
        this.dependencyIds = data().deepCopy(fields()[8].schema(), other.dependencyIds);
        fieldSetFlags()[8] = true;
      }
      if (isValidValue(fields()[9], other.numberOfProcesses)) {
        this.numberOfProcesses = data().deepCopy(fields()[9].schema(), other.numberOfProcesses);
        fieldSetFlags()[9] = true;
      }
      if (isValidValue(fields()[10], other.numberOfProcessesByMachine)) {
        this.numberOfProcessesByMachine = data().deepCopy(fields()[10].schema(), other.numberOfProcessesByMachine);
        fieldSetFlags()[10] = true;
      }
      if (isValidValue(fields()[11], other.submissionTime)) {
        this.submissionTime = data().deepCopy(fields()[11].schema(), other.submissionTime);
        fieldSetFlags()[11] = true;
      }
      if (isValidValue(fields()[12], other.description)) {
        this.description = data().deepCopy(fields()[12].schema(), other.description);
        fieldSetFlags()[12] = true;
      }
      if (isValidValue(fields()[13], other.priority)) {
        this.priority = data().deepCopy(fields()[13].schema(), other.priority);
        fieldSetFlags()[13] = true;
      }
      if (isValidValue(fields()[14], other.multipleExecution)) {
        this.multipleExecution = data().deepCopy(fields()[14].schema(), other.multipleExecution);
        fieldSetFlags()[14] = true;
      }
      if (isValidValue(fields()[15], other.specificationType)) {
        this.specificationType = data().deepCopy(fields()[15].schema(), other.specificationType);
        fieldSetFlags()[15] = true;
      }
      if (isValidValue(fields()[16], other.specification)) {
        this.specification = data().deepCopy(fields()[16].schema(), other.specification);
        fieldSetFlags()[16] = true;
      }
    }

    /**
      * Gets the value of the 'eventId' field.
      * The job event identifier
      * @return The value.
      */
    public java.lang.String getEventId() {
      return eventId;
    }

    /**
      * Sets the value of the 'eventId' field.
      * The job event identifier
      * @param value The value of 'eventId'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setEventId(java.lang.String value) {
      validate(fields()[0], value);
      this.eventId = value;
      fieldSetFlags()[0] = true;
      return this;
    }

    /**
      * Checks whether the 'eventId' field has been set.
      * The job event identifier
      * @return True if the 'eventId' field has been set, false otherwise.
      */
    public boolean hasEventId() {
      return fieldSetFlags()[0];
    }


    /**
      * Clears the value of the 'eventId' field.
      * The job event identifier
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearEventId() {
      eventId = null;
      fieldSetFlags()[0] = false;
      return this;
    }

    /**
      * Gets the value of the 'timestamp' field.
      * The job event timestamp
      * @return The value.
      */
    public java.lang.Long getTimestamp() {
      return timestamp;
    }

    /**
      * Sets the value of the 'timestamp' field.
      * The job event timestamp
      * @param value The value of 'timestamp'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setTimestamp(long value) {
      validate(fields()[1], value);
      this.timestamp = value;
      fieldSetFlags()[1] = true;
      return this;
    }

    /**
      * Checks whether the 'timestamp' field has been set.
      * The job event timestamp
      * @return True if the 'timestamp' field has been set, false otherwise.
      */
    public boolean hasTimestamp() {
      return fieldSetFlags()[1];
    }


    /**
      * Clears the value of the 'timestamp' field.
      * The job event timestamp
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearTimestamp() {
      fieldSetFlags()[1] = false;
      return this;
    }

    /**
      * Gets the value of the 'jobId' field.
      * The identification of the job
      * @return The value.
      */
    public java.lang.String getJobId() {
      return jobId;
    }

    /**
      * Sets the value of the 'jobId' field.
      * The identification of the job
      * @param value The value of 'jobId'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setJobId(java.lang.String value) {
      validate(fields()[2], value);
      this.jobId = value;
      fieldSetFlags()[2] = true;
      return this;
    }

    /**
      * Checks whether the 'jobId' field has been set.
      * The identification of the job
      * @return True if the 'jobId' field has been set, false otherwise.
      */
    public boolean hasJobId() {
      return fieldSetFlags()[2];
    }


    /**
      * Clears the value of the 'jobId' field.
      * The identification of the job
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearJobId() {
      jobId = null;
      fieldSetFlags()[2] = false;
      return this;
    }

    /**
      * Gets the value of the 'groupId' field.
      * Job group identifier
      * @return The value.
      */
    public java.lang.String getGroupId() {
      return groupId;
    }

    /**
      * Sets the value of the 'groupId' field.
      * Job group identifier
      * @param value The value of 'groupId'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setGroupId(java.lang.String value) {
      validate(fields()[3], value);
      this.groupId = value;
      fieldSetFlags()[3] = true;
      return this;
    }

    /**
      * Checks whether the 'groupId' field has been set.
      * Job group identifier
      * @return True if the 'groupId' field has been set, false otherwise.
      */
    public boolean hasGroupId() {
      return fieldSetFlags()[3];
    }


    /**
      * Clears the value of the 'groupId' field.
      * Job group identifier
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearGroupId() {
      groupId = null;
      fieldSetFlags()[3] = false;
      return this;
    }

    /**
      * Gets the value of the 'projectId' field.
      * Project identifier
      * @return The value.
      */
    public java.lang.String getProjectId() {
      return projectId;
    }

    /**
      * Sets the value of the 'projectId' field.
      * Project identifier
      * @param value The value of 'projectId'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setProjectId(java.lang.String value) {
      validate(fields()[4], value);
      this.projectId = value;
      fieldSetFlags()[4] = true;
      return this;
    }

    /**
      * Checks whether the 'projectId' field has been set.
      * Project identifier
      * @return True if the 'projectId' field has been set, false otherwise.
      */
    public boolean hasProjectId() {
      return fieldSetFlags()[4];
    }


    /**
      * Clears the value of the 'projectId' field.
      * Project identifier
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearProjectId() {
      projectId = null;
      fieldSetFlags()[4] = false;
      return this;
    }

    /**
      * Gets the value of the 'owner' field.
      * Owner's user identifier
      * @return The value.
      */
    public java.lang.String getOwner() {
      return owner;
    }

    /**
      * Sets the value of the 'owner' field.
      * Owner's user identifier
      * @param value The value of 'owner'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setOwner(java.lang.String value) {
      validate(fields()[5], value);
      this.owner = value;
      fieldSetFlags()[5] = true;
      return this;
    }

    /**
      * Checks whether the 'owner' field has been set.
      * Owner's user identifier
      * @return True if the 'owner' field has been set, false otherwise.
      */
    public boolean hasOwner() {
      return fieldSetFlags()[5];
    }


    /**
      * Clears the value of the 'owner' field.
      * Owner's user identifier
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearOwner() {
      owner = null;
      fieldSetFlags()[5] = false;
      return this;
    }

    /**
      * Gets the value of the 'automaticallyMachineSelection' field.
      * Flag to indicate option for automatically machine selection
      * @return The value.
      */
    public java.lang.Boolean getAutomaticallyMachineSelection() {
      return automaticallyMachineSelection;
    }

    /**
      * Sets the value of the 'automaticallyMachineSelection' field.
      * Flag to indicate option for automatically machine selection
      * @param value The value of 'automaticallyMachineSelection'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setAutomaticallyMachineSelection(boolean value) {
      validate(fields()[6], value);
      this.automaticallyMachineSelection = value;
      fieldSetFlags()[6] = true;
      return this;
    }

    /**
      * Checks whether the 'automaticallyMachineSelection' field has been set.
      * Flag to indicate option for automatically machine selection
      * @return True if the 'automaticallyMachineSelection' field has been set, false otherwise.
      */
    public boolean hasAutomaticallyMachineSelection() {
      return fieldSetFlags()[6];
    }


    /**
      * Clears the value of the 'automaticallyMachineSelection' field.
      * Flag to indicate option for automatically machine selection
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearAutomaticallyMachineSelection() {
      fieldSetFlags()[6] = false;
      return this;
    }

    /**
      * Gets the value of the 'selectedMachines' field.
      * Machines that user selected for execution.
      * @return The value.
      */
    public java.util.List<java.lang.String> getSelectedMachines() {
      return selectedMachines;
    }

    /**
      * Sets the value of the 'selectedMachines' field.
      * Machines that user selected for execution.
      * @param value The value of 'selectedMachines'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setSelectedMachines(java.util.List<java.lang.String> value) {
      validate(fields()[7], value);
      this.selectedMachines = value;
      fieldSetFlags()[7] = true;
      return this;
    }

    /**
      * Checks whether the 'selectedMachines' field has been set.
      * Machines that user selected for execution.
      * @return True if the 'selectedMachines' field has been set, false otherwise.
      */
    public boolean hasSelectedMachines() {
      return fieldSetFlags()[7];
    }


    /**
      * Clears the value of the 'selectedMachines' field.
      * Machines that user selected for execution.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearSelectedMachines() {
      selectedMachines = null;
      fieldSetFlags()[7] = false;
      return this;
    }

    /**
      * Gets the value of the 'dependencyIds' field.
      * Array of job ids that need to successfully finish for this one to run.
      * @return The value.
      */
    public java.util.List<java.lang.String> getDependencyIds() {
      return dependencyIds;
    }

    /**
      * Sets the value of the 'dependencyIds' field.
      * Array of job ids that need to successfully finish for this one to run.
      * @param value The value of 'dependencyIds'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setDependencyIds(java.util.List<java.lang.String> value) {
      validate(fields()[8], value);
      this.dependencyIds = value;
      fieldSetFlags()[8] = true;
      return this;
    }

    /**
      * Checks whether the 'dependencyIds' field has been set.
      * Array of job ids that need to successfully finish for this one to run.
      * @return True if the 'dependencyIds' field has been set, false otherwise.
      */
    public boolean hasDependencyIds() {
      return fieldSetFlags()[8];
    }


    /**
      * Clears the value of the 'dependencyIds' field.
      * Array of job ids that need to successfully finish for this one to run.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearDependencyIds() {
      dependencyIds = null;
      fieldSetFlags()[8] = false;
      return this;
    }

    /**
      * Gets the value of the 'numberOfProcesses' field.
      * The total number of processes. In the case of multiple execution, this number can be more than one.
      * @return The value.
      */
    public java.lang.Integer getNumberOfProcesses() {
      return numberOfProcesses;
    }

    /**
      * Sets the value of the 'numberOfProcesses' field.
      * The total number of processes. In the case of multiple execution, this number can be more than one.
      * @param value The value of 'numberOfProcesses'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setNumberOfProcesses(int value) {
      validate(fields()[9], value);
      this.numberOfProcesses = value;
      fieldSetFlags()[9] = true;
      return this;
    }

    /**
      * Checks whether the 'numberOfProcesses' field has been set.
      * The total number of processes. In the case of multiple execution, this number can be more than one.
      * @return True if the 'numberOfProcesses' field has been set, false otherwise.
      */
    public boolean hasNumberOfProcesses() {
      return fieldSetFlags()[9];
    }


    /**
      * Clears the value of the 'numberOfProcesses' field.
      * The total number of processes. In the case of multiple execution, this number can be more than one.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearNumberOfProcesses() {
      fieldSetFlags()[9] = false;
      return this;
    }

    /**
      * Gets the value of the 'numberOfProcessesByMachine' field.
      * The number of processes by machine. In the case of multiple execution, this number can be more than one.
      * @return The value.
      */
    public java.lang.Integer getNumberOfProcessesByMachine() {
      return numberOfProcessesByMachine;
    }

    /**
      * Sets the value of the 'numberOfProcessesByMachine' field.
      * The number of processes by machine. In the case of multiple execution, this number can be more than one.
      * @param value The value of 'numberOfProcessesByMachine'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setNumberOfProcessesByMachine(int value) {
      validate(fields()[10], value);
      this.numberOfProcessesByMachine = value;
      fieldSetFlags()[10] = true;
      return this;
    }

    /**
      * Checks whether the 'numberOfProcessesByMachine' field has been set.
      * The number of processes by machine. In the case of multiple execution, this number can be more than one.
      * @return True if the 'numberOfProcessesByMachine' field has been set, false otherwise.
      */
    public boolean hasNumberOfProcessesByMachine() {
      return fieldSetFlags()[10];
    }


    /**
      * Clears the value of the 'numberOfProcessesByMachine' field.
      * The number of processes by machine. In the case of multiple execution, this number can be more than one.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearNumberOfProcessesByMachine() {
      fieldSetFlags()[10] = false;
      return this;
    }

    /**
      * Gets the value of the 'submissionTime' field.
      * The timestamp of job submission.
      * @return The value.
      */
    public java.lang.Long getSubmissionTime() {
      return submissionTime;
    }

    /**
      * Sets the value of the 'submissionTime' field.
      * The timestamp of job submission.
      * @param value The value of 'submissionTime'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setSubmissionTime(long value) {
      validate(fields()[11], value);
      this.submissionTime = value;
      fieldSetFlags()[11] = true;
      return this;
    }

    /**
      * Checks whether the 'submissionTime' field has been set.
      * The timestamp of job submission.
      * @return True if the 'submissionTime' field has been set, false otherwise.
      */
    public boolean hasSubmissionTime() {
      return fieldSetFlags()[11];
    }


    /**
      * Clears the value of the 'submissionTime' field.
      * The timestamp of job submission.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearSubmissionTime() {
      fieldSetFlags()[11] = false;
      return this;
    }

    /**
      * Gets the value of the 'description' field.
      * The job description.
      * @return The value.
      */
    public java.lang.String getDescription() {
      return description;
    }

    /**
      * Sets the value of the 'description' field.
      * The job description.
      * @param value The value of 'description'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setDescription(java.lang.String value) {
      validate(fields()[12], value);
      this.description = value;
      fieldSetFlags()[12] = true;
      return this;
    }

    /**
      * Checks whether the 'description' field has been set.
      * The job description.
      * @return True if the 'description' field has been set, false otherwise.
      */
    public boolean hasDescription() {
      return fieldSetFlags()[12];
    }


    /**
      * Clears the value of the 'description' field.
      * The job description.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearDescription() {
      description = null;
      fieldSetFlags()[12] = false;
      return this;
    }

    /**
      * Gets the value of the 'priority' field.
      * Execution priority.
      * @return The value.
      */
    public java.lang.Integer getPriority() {
      return priority;
    }

    /**
      * Sets the value of the 'priority' field.
      * Execution priority.
      * @param value The value of 'priority'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setPriority(int value) {
      validate(fields()[13], value);
      this.priority = value;
      fieldSetFlags()[13] = true;
      return this;
    }

    /**
      * Checks whether the 'priority' field has been set.
      * Execution priority.
      * @return True if the 'priority' field has been set, false otherwise.
      */
    public boolean hasPriority() {
      return fieldSetFlags()[13];
    }


    /**
      * Clears the value of the 'priority' field.
      * Execution priority.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearPriority() {
      fieldSetFlags()[13] = false;
      return this;
    }

    /**
      * Gets the value of the 'multipleExecution' field.
      * If the submission will create multiple jobs.
      * @return The value.
      */
    public java.lang.Boolean getMultipleExecution() {
      return multipleExecution;
    }

    /**
      * Sets the value of the 'multipleExecution' field.
      * If the submission will create multiple jobs.
      * @param value The value of 'multipleExecution'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setMultipleExecution(boolean value) {
      validate(fields()[14], value);
      this.multipleExecution = value;
      fieldSetFlags()[14] = true;
      return this;
    }

    /**
      * Checks whether the 'multipleExecution' field has been set.
      * If the submission will create multiple jobs.
      * @return True if the 'multipleExecution' field has been set, false otherwise.
      */
    public boolean hasMultipleExecution() {
      return fieldSetFlags()[14];
    }


    /**
      * Clears the value of the 'multipleExecution' field.
      * If the submission will create multiple jobs.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearMultipleExecution() {
      fieldSetFlags()[14] = false;
      return this;
    }

    /**
      * Gets the value of the 'specificationType' field.
      * @return The value.
      */
    public br.pucrio.tecgraf.soma.job.SpecificationType getSpecificationType() {
      return specificationType;
    }

    /**
      * Sets the value of the 'specificationType' field.
      * @param value The value of 'specificationType'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setSpecificationType(br.pucrio.tecgraf.soma.job.SpecificationType value) {
      validate(fields()[15], value);
      this.specificationType = value;
      fieldSetFlags()[15] = true;
      return this;
    }

    /**
      * Checks whether the 'specificationType' field has been set.
      * @return True if the 'specificationType' field has been set, false otherwise.
      */
    public boolean hasSpecificationType() {
      return fieldSetFlags()[15];
    }


    /**
      * Clears the value of the 'specificationType' field.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearSpecificationType() {
      specificationType = null;
      fieldSetFlags()[15] = false;
      return this;
    }

    /**
      * Gets the value of the 'specification' field.
      * If the job is related to an algorithm or to a flow.
      * @return The value.
      */
    public java.lang.Object getSpecification() {
      return specification;
    }

    /**
      * Sets the value of the 'specification' field.
      * If the job is related to an algorithm or to a flow.
      * @param value The value of 'specification'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder setSpecification(java.lang.Object value) {
      validate(fields()[16], value);
      this.specification = value;
      fieldSetFlags()[16] = true;
      return this;
    }

    /**
      * Checks whether the 'specification' field has been set.
      * If the job is related to an algorithm or to a flow.
      * @return True if the 'specification' field has been set, false otherwise.
      */
    public boolean hasSpecification() {
      return fieldSetFlags()[16];
    }


    /**
      * Clears the value of the 'specification' field.
      * If the job is related to an algorithm or to a flow.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobScheduledEvent.Builder clearSpecification() {
      specification = null;
      fieldSetFlags()[16] = false;
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    public JobScheduledEvent build() {
      try {
        JobScheduledEvent record = new JobScheduledEvent();
        record.eventId = fieldSetFlags()[0] ? this.eventId : (java.lang.String) defaultValue(fields()[0]);
        record.timestamp = fieldSetFlags()[1] ? this.timestamp : (java.lang.Long) defaultValue(fields()[1]);
        record.jobId = fieldSetFlags()[2] ? this.jobId : (java.lang.String) defaultValue(fields()[2]);
        record.groupId = fieldSetFlags()[3] ? this.groupId : (java.lang.String) defaultValue(fields()[3]);
        record.projectId = fieldSetFlags()[4] ? this.projectId : (java.lang.String) defaultValue(fields()[4]);
        record.owner = fieldSetFlags()[5] ? this.owner : (java.lang.String) defaultValue(fields()[5]);
        record.automaticallyMachineSelection = fieldSetFlags()[6] ? this.automaticallyMachineSelection : (java.lang.Boolean) defaultValue(fields()[6]);
        record.selectedMachines = fieldSetFlags()[7] ? this.selectedMachines : (java.util.List<java.lang.String>) defaultValue(fields()[7]);
        record.dependencyIds = fieldSetFlags()[8] ? this.dependencyIds : (java.util.List<java.lang.String>) defaultValue(fields()[8]);
        record.numberOfProcesses = fieldSetFlags()[9] ? this.numberOfProcesses : (java.lang.Integer) defaultValue(fields()[9]);
        record.numberOfProcessesByMachine = fieldSetFlags()[10] ? this.numberOfProcessesByMachine : (java.lang.Integer) defaultValue(fields()[10]);
        record.submissionTime = fieldSetFlags()[11] ? this.submissionTime : (java.lang.Long) defaultValue(fields()[11]);
        record.description = fieldSetFlags()[12] ? this.description : (java.lang.String) defaultValue(fields()[12]);
        record.priority = fieldSetFlags()[13] ? this.priority : (java.lang.Integer) defaultValue(fields()[13]);
        record.multipleExecution = fieldSetFlags()[14] ? this.multipleExecution : (java.lang.Boolean) defaultValue(fields()[14]);
        record.specificationType = fieldSetFlags()[15] ? this.specificationType : (br.pucrio.tecgraf.soma.job.SpecificationType) defaultValue(fields()[15]);
        record.specification = fieldSetFlags()[16] ? this.specification : (java.lang.Object) defaultValue(fields()[16]);
        return record;
      } catch (java.lang.Exception e) {
        throw new org.apache.avro.AvroRuntimeException(e);
      }
    }
  }

  @SuppressWarnings("unchecked")
  private static final org.apache.avro.io.DatumWriter<JobScheduledEvent>
    WRITER$ = (org.apache.avro.io.DatumWriter<JobScheduledEvent>)MODEL$.createDatumWriter(SCHEMA$);

  @Override public void writeExternal(java.io.ObjectOutput out)
    throws java.io.IOException {
    WRITER$.write(this, SpecificData.getEncoder(out));
  }

  @SuppressWarnings("unchecked")
  private static final org.apache.avro.io.DatumReader<JobScheduledEvent>
    READER$ = (org.apache.avro.io.DatumReader<JobScheduledEvent>)MODEL$.createDatumReader(SCHEMA$);

  @Override public void readExternal(java.io.ObjectInput in)
    throws java.io.IOException {
    READER$.read(this, SpecificData.getDecoder(in));
  }

}
