/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api.model;

import br.pucrio.tecgraf.soma.job.application.JsonUndefined;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.Min;

@JsonPropertyOrder(value={"lineNumber", "multiflowId", "multiflowName", "jobId", "replicaDependencyRaw", "version"})
@JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=JsonUndefined.class)
public class ReplicaJobResponse {
    public static final String JSON_PROPERTY_LINE_NUMBER = "lineNumber";
    @JsonProperty(value="lineNumber")
    private Integer lineNumber;
    public static final String JSON_PROPERTY_MULTIFLOW_ID = "multiflowId";
    @JsonProperty(value="multiflowId")
    private Long multiflowId;
    public static final String JSON_PROPERTY_MULTIFLOW_NAME = "multiflowName";
    @JsonProperty(value="multiflowName")
    private String multiflowName;
    public static final String JSON_PROPERTY_JOB_ID = "jobId";
    @JsonProperty(value="jobId")
    private String jobId;
    public static final String JSON_PROPERTY_REPLICA_DEPENDENCY_RAW = "replicaDependencyRaw";
    @JsonProperty(value="replicaDependencyRaw")
    private String replicaDependencyRaw;
    public static final String JSON_PROPERTY_VERSION = "version";
    @JsonProperty(value="version")
    private Integer version;

    public ReplicaJobResponse lineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    @JsonProperty(value="lineNumber")
    @ApiModelProperty(value="The replica number.")
    @Min(value=1L)
    public @Min(value=1L) Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public ReplicaJobResponse multiflowId(Long multiflowId) {
        this.multiflowId = multiflowId;
        return this;
    }

    @JsonProperty(value="multiflowId")
    @ApiModelProperty(value="The multiflow id.")
    public Long getMultiflowId() {
        return this.multiflowId;
    }

    public void setMultiflowId(Long multiflowId) {
        this.multiflowId = multiflowId;
    }

    public ReplicaJobResponse multiflowName(String multiflowName) {
        this.multiflowName = multiflowName;
        return this;
    }

    @JsonProperty(value="multiflowName")
    @ApiModelProperty(value="The multiflow name.")
    public String getMultiflowName() {
        return this.multiflowName;
    }

    public void setMultiflowName(String multiflowName) {
        this.multiflowName = multiflowName;
    }

    public ReplicaJobResponse jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @JsonProperty(value="jobId")
    @ApiModelProperty(value="The job string identifier.")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public ReplicaJobResponse replicaDependencyRaw(String replicaDependencyRaw) {
        this.replicaDependencyRaw = replicaDependencyRaw;
        return this;
    }

    @JsonProperty(value="replicaDependencyRaw")
    @ApiModelProperty(value="The raw string that created the job dependencies.")
    public String getReplicaDependencyRaw() {
        return this.replicaDependencyRaw;
    }

    public void setReplicaDependencyRaw(String replicaDependencyRaw) {
        this.replicaDependencyRaw = replicaDependencyRaw;
    }

    public ReplicaJobResponse version(Integer version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="version")
    @ApiModelProperty(value="The replica execution version.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaJobResponse replicaJobResponse = (ReplicaJobResponse)o;
        return Objects.equals(this.lineNumber, replicaJobResponse.lineNumber) && Objects.equals(this.multiflowId, replicaJobResponse.multiflowId) && Objects.equals(this.multiflowName, replicaJobResponse.multiflowName) && Objects.equals(this.jobId, replicaJobResponse.jobId) && Objects.equals(this.replicaDependencyRaw, replicaJobResponse.replicaDependencyRaw) && Objects.equals(this.version, replicaJobResponse.version);
    }

    public int hashCode() {
        return Objects.hash(this.lineNumber, this.multiflowId, this.multiflowName, this.jobId, this.replicaDependencyRaw, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplicaJobResponse {\n");
        sb.append("    lineNumber: ").append(this.toIndentedString((Object)this.lineNumber)).append("\n");
        sb.append("    multiflowId: ").append(this.toIndentedString((Object)this.multiflowId)).append("\n");
        sb.append("    multiflowName: ").append(this.toIndentedString((Object)this.multiflowName)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString((Object)this.jobId)).append("\n");
        sb.append("    replicaDependencyRaw: ").append(this.toIndentedString((Object)this.replicaDependencyRaw)).append("\n");
        sb.append("    version: ").append(this.toIndentedString((Object)this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

