/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import br.pucrio.tecgraf.soma.job.application.service.JobService;
import br.pucrio.tecgraf.soma.job.application.service.ProjectService;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import java.util.List;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobAppService {
    private static final Logger LOG = Logger.getLogger(JobAppService.class);
    @Value(value="${job.history.project.permission.check.enable}")
    public boolean checkProjectPermissionEnabled;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private JobService jobService;

    @Transactional
    public List<JobAlgorithm> findDistinctAlgorithms(String rsqlQuery) {
        rsqlQuery = this.filterUserProjects(rsqlQuery);
        return this.jobService.findDistinctAlgorithms(rsqlQuery);
    }

    @Transactional
    public void editJobComment(String jobId, String newComment) throws ForbiddenException {
        Job job = null;
        try {
            job = this.jobService.findJobByStringId(jobId);
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Error retrieving job with id %s", jobId), (Throwable)e);
        }
        if (job == null) {
            throw new NotFoundException(String.format("Job not found: %s", jobId));
        }
        if (!this.projectService.hasPermission(job.getProjectId())) {
            throw new ForbiddenException("User has no permission to edit this job");
        }
        try {
            this.jobService.editJobComment(jobId, newComment);
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Error updating job with id %s", jobId), (Throwable)e);
        }
    }

    @Transactional
    public void markJobAsDeleted(String jobId) {
        this.jobService.markJobAsDeleted(jobId);
    }

    @Transactional
    public void markJobsAsDeleted(List<String> jobIds) {
        this.jobService.markJobsAsDeleted(jobIds);
    }

    @Transactional
    public void findJobs(String rsqlQuery, int limit, int offset, boolean ascending, String sortAttribute, JobResponse response) {
        rsqlQuery = this.filterUserProjectsAndHandleDeleted(rsqlQuery);
        this.jobService.findJobs(rsqlQuery, limit, offset, ascending, sortAttribute, response);
    }

    @Transactional
    public void findGroupedJobs(String rsqlQuery, int limit, int offset, boolean ascending, String sortAttribute, JobResponse response) {
        rsqlQuery = this.filterUserProjectsAndHandleDeleted(rsqlQuery);
        this.jobService.findGroupedJobs(rsqlQuery, limit, offset, ascending, sortAttribute, response);
    }

    public String filterUserProjects(String q) {
        String projectsQuery = "";
        if (this.checkProjectPermissionEnabled) {
            LOG.info((Object)"Checking user project permission");
            projectsQuery = this.getUserProjectsPredicate("job.projectId");
        } else {
            LOG.info((Object)"Skipping user project permission check");
        }
        if (q == null || q.length() == 0) {
            q = projectsQuery;
        } else if (projectsQuery.length() > 0) {
            q = String.format("(%s);(%s)", q, projectsQuery);
        }
        return q;
    }

    public String filterUserProjectsAndHandleDeleted(String q) {
        String notDeletedQuery = "isDeleted==false";
        if (q == null || q.length() == 0) {
            q = notDeletedQuery;
        } else if (!q.contains("isDeleted")) {
            q = String.format("(%s);(%s)", q, notDeletedQuery);
        }
        if (this.checkProjectPermissionEnabled) {
            LOG.info((Object)"Checking user project permission");
            String projectsQuery = this.getUserProjectsPredicate("projectId");
            if (projectsQuery.length() > 0) {
                q = String.format("(%s);(%s)", q, projectsQuery);
            }
        } else {
            LOG.info((Object)"Skipping user project permission check");
        }
        return q;
    }

    public String getUserProjectsPredicate(String projectColumn) throws NotFoundException {
        List userProjects = this.projectService.getUserProjects();
        if (userProjects.isEmpty()) {
            String msg = "User has access to no projects";
            LOG.info((Object)msg);
            throw new NotFoundException(msg);
        }
        StringBuilder projectsQuery = new StringBuilder(projectColumn);
        projectsQuery.append("=in=(");
        for (String project : userProjects) {
            projectsQuery.append(project);
            projectsQuery.append(",");
        }
        projectsQuery.deleteCharAt(projectsQuery.lastIndexOf(","));
        projectsQuery.append(")");
        return projectsQuery.toString();
    }
}

