package br.pucrio.tecgraf.soma.job.api;

import br.pucrio.tecgraf.soma.job.api.MultiflowApiService;
import br.pucrio.tecgraf.soma.job.api.factories.MultiflowApiServiceFactory;

import io.swagger.annotations.ApiParam;
import io.swagger.jaxrs.*;

import br.pucrio.tecgraf.soma.job.api.model.Multiflow;
import br.pucrio.tecgraf.soma.job.api.model.MultiflowBasicResponse;
import br.pucrio.tecgraf.soma.job.api.model.MultiflowFullResponse;
import br.pucrio.tecgraf.soma.job.api.model.MultiflowPatch;

import java.util.Map;
import java.util.List;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;

import java.io.InputStream;

import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;

import jakarta.servlet.ServletConfig;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.*;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

@Path("/multiflow")


@io.swagger.annotations.Api(description = "the multiflow API")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJerseyServerCodegen", date = "2025-12-05T18:35:28.044883283Z[UTC]", comments = "Generator version: 7.10.0")
public class MultiflowApi  {
   private final MultiflowApiService delegate;

   public MultiflowApi(@Context ServletConfig servletContext) {
      MultiflowApiService delegate = null;

      if (servletContext != null) {
         String implClass = servletContext.getInitParameter("MultiflowApi.implementation");
         if (implClass != null && !"".equals(implClass.trim())) {
            try {
               delegate = (MultiflowApiService) Class.forName(implClass).getDeclaredConstructor().newInstance();
            } catch (Exception e) {
               throw new RuntimeException(e);
            }
         }
      }

      if (delegate == null) {
         delegate = MultiflowApiServiceFactory.getMultiflowApi();
      }

      this.delegate = delegate;
   }

    @jakarta.ws.rs.GET
    
    
    @Produces({ "application/json;" })
    @io.swagger.annotations.ApiOperation(value = "Get multiflows from a certain project", notes = "This endpoint list all multiflows from a certain project", response = MultiflowFullResponse.class, tags={ "Multiflows", })
    @io.swagger.annotations.ApiResponses(value = {
        @io.swagger.annotations.ApiResponse(code = 200, message = "Successful operation.", response = MultiflowFullResponse.class),
        @io.swagger.annotations.ApiResponse(code = 400, message = "Invalid or missing parameters.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 401, message = "No authorization token.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 403, message = "The authenticated user does not have permission to access the project.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 500, message = "Processing error occurred during the multiflows search.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 503, message = "Server is currently unable to handle the request.", response = Void.class)
    })
    public Response multiflowGet(@ApiParam(value = "Project identifier", required = true) @QueryParam("projectId") @NotNull  String projectId,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale")  String locale,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.multiflowGet(projectId, locale, securityContext);
    }
    @jakarta.ws.rs.DELETE
    @Path("/{multiflowId}")
    
    
    @io.swagger.annotations.ApiOperation(value = "Archive a multiflow.", notes = "This endpoint archives a multiflow, removing from the list of searchable multiflows.", response = Void.class, tags={ "Multiflows", })
    @io.swagger.annotations.ApiResponses(value = {
        @io.swagger.annotations.ApiResponse(code = 204, message = "Successful operation.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 400, message = "Invalid or missing parameters.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 403, message = "if the authenticated user is not authorized to archive multiflows. Only the job owner or the administrator can archive a multiflow.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 404, message = "Multiflow identifier not found.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 500, message = "Processing error occurred during the multiflow archive operation.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 503, message = "Server is currently unable to handle the request.", response = Void.class)
    })
    public Response multiflowMultiflowIdDelete(@ApiParam(value = "Multiflow identifier", required = true) @PathParam("multiflowId") @NotNull  Long multiflowId,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale")  String locale,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.multiflowMultiflowIdDelete(multiflowId, locale, securityContext);
    }
    @jakarta.ws.rs.GET
    @Path("/{multiflowId}")
    
    @Produces({ "application/json" })
    @io.swagger.annotations.ApiOperation(value = "Get a specific multiflow from its unique identifier", notes = "This endpoint gets a single multiflow from its unique identifier", response = MultiflowFullResponse.class, tags={ "Multiflows", })
    @io.swagger.annotations.ApiResponses(value = {
        @io.swagger.annotations.ApiResponse(code = 200, message = "Successful operation.", response = MultiflowFullResponse.class),
        @io.swagger.annotations.ApiResponse(code = 400, message = "Invalid or missing parameters.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 401, message = "No authorization token.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 403, message = "The authenticated user does not have permission to access the project.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 404, message = "Multiflow identifier not found.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 500, message = "Processing error occurred during the multiflow search.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 503, message = "Server is currently unable to handle the request.", response = Void.class)
    })
    public Response multiflowMultiflowIdGet(@ApiParam(value = "Multiflow identifier", required = true) @PathParam("multiflowId") @NotNull  Long multiflowId,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale")  String locale,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.multiflowMultiflowIdGet(multiflowId, locale, securityContext);
    }
    @jakarta.ws.rs.PATCH
    @Path("/{multiflowId}")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @io.swagger.annotations.ApiOperation(value = "Updates a multiflow from its unique identifier.", notes = "This endpoint updates the file name and file path of a multiflow from its unique identifier. If no file name is passed then the file path is used as file name. It can also update the name of the multiflow or its parameter mapping (if it's passed).", response = MultiflowFullResponse.class, tags={ "Multiflows", })
    @io.swagger.annotations.ApiResponses(value = {
        @io.swagger.annotations.ApiResponse(code = 200, message = "Successful operation.", response = MultiflowFullResponse.class),
        @io.swagger.annotations.ApiResponse(code = 400, message = "Invalid or missing parameters.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 401, message = "No authorization token.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 403, message = "The authenticated user does not have permission to access the project.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 404, message = "Multiflow identifier not found.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 500, message = "Processing error occurred during the request.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 503, message = "Server is currently unable to handle the request.", response = Void.class)
    })
    public Response multiflowMultiflowIdPatch(@ApiParam(value = "Multiflow identifier", required = true) @PathParam("multiflowId") @NotNull  Long multiflowId,@ApiParam(value = "Required information to update the file name, file path, parameter mapping, or name of a multiflow.", required = true) @NotNull @Valid  MultiflowPatch multiflowPatch,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale")  String locale,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.multiflowMultiflowIdPatch(multiflowId, multiflowPatch, locale, securityContext);
    }
    @jakarta.ws.rs.POST
    
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @io.swagger.annotations.ApiOperation(value = "Create a multiflow", notes = "This endpoint creates a multiflow, which is combination of flow with replica table.", response = MultiflowBasicResponse.class, tags={ "Multiflows", })
    @io.swagger.annotations.ApiResponses(value = {
        @io.swagger.annotations.ApiResponse(code = 201, message = "New multiflow created.", response = MultiflowBasicResponse.class),
        @io.swagger.annotations.ApiResponse(code = 400, message = "Missing body parameter(s).", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 401, message = "No authorization token.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 403, message = "The authenticated user does not have permission to access the project.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 404, message = "Multiflow not found.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 500, message = "Processing error occurred during the multiflow creation.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 503, message = "Server is currently unable to handle the request.", response = Void.class)
    })
    public Response multiflowPost(@ApiParam(value = "Required information to create a multiflow", required = true) @NotNull @Valid  Multiflow multiflow,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale")  String locale,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.multiflowPost(multiflow, locale, securityContext);
    }
}
