package br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification;

import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.List;

public class GroupsInListSpecification extends JPASpecification<Job> {

  private List<String> ids;

  public GroupsInListSpecification(List<String> ids) {
    this.ids = ids;
  }

  public boolean isSatisfiedBy(Job element) {
    for (String id : this.ids) {
      if (id.equals(element.getJobId())) {
        return true;
      }
    }
    return false;
  }

  @Override
  public Predicate toPredicate(Root<Job> root, CriteriaBuilder cb) {
    CriteriaBuilder.In in = cb.in(root.get("groupId"));
    ids.forEach(in::value);

    return in;
  }
}
