/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.store;

import ca.uhn.hl7v2.conf.store.CodeStore;
import ca.uhn.hl7v2.conf.store.FileProfileStore;
import ca.uhn.hl7v2.conf.store.ProfileStore;
import ca.uhn.hl7v2.util.Home;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class ProfileStoreFactory {
    private static ProfileStore instance;
    private static ArrayList codeStores;

    static {
        codeStores = new ArrayList();
    }

    public static synchronized ProfileStore getProfileStore() {
        if (instance == null) {
            instance = new FileProfileStore(String.valueOf(Home.getHomeDirectory().getAbsolutePath()) + "/profiles");
        }
        return instance;
    }

    public static synchronized void setStore(ProfileStore store) {
        instance = store;
    }

    public static void addCodeStore(CodeStore store) {
        ProfileStoreFactory.addCodeStore(store, ".*");
    }

    public static void addCodeStore(CodeStore store, String profileID) {
        Pattern p = Pattern.compile(profileID);
        ProfileStoreFactory.addCodeStore(store, p);
    }

    public static void addCodeStore(CodeStore store, Pattern profileIdPattern) {
        codeStores.add(new CodeStoreRegistration(profileIdPattern, store));
    }

    public static CodeStore getCodeStore(String profileID, String codeSystem) {
        CodeStore store = null;
        int i = 0;
        while (i < codeStores.size() && store == null) {
            CodeStoreRegistration reg = (CodeStoreRegistration)codeStores.get(i);
            if (reg.pattern.matcher(profileID).matches() && reg.store.knowsCodes(codeSystem)) {
                store = reg.store;
            }
            ++i;
        }
        return store;
    }

    private static class CodeStoreRegistration {
        public Pattern pattern;
        public CodeStore store;

        public CodeStoreRegistration(Pattern p, CodeStore cs) {
            this.pattern = p;
            this.store = cs;
        }
    }
}

