/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ParseChecker {
    private static final HapiLog log = HapiLogFactory.getHapiLog(ParseChecker.class);

    public static void checkParse(String originalMessageText, Message parsedMessage, Parser parser) throws HL7Exception, IOException {
        log.info("ParseChecker is checking parse integrity (turn this off if you are not testing)");
        String newMessageText = parser.encode(parsedMessage);
        log.info("******************* Comparing Messages ****************\r\n");
        log.info("Original:           " + originalMessageText + "\r\n");
        log.info("Parsed and Encoded: " + newMessageText + "\r\n");
        if (!originalMessageText.equals(newMessageText)) {
            StringTokenizer tok = new StringTokenizer(originalMessageText, "\r");
            ArrayList<String> one = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                String seg = tok.nextToken();
                if (seg.length() <= 4) continue;
                one.add(seg);
            }
            tok = new StringTokenizer(newMessageText, "\r");
            ArrayList<String> two = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                String seg = tok.nextToken();
                if (seg.length() <= 4) continue;
                two.add(ParseChecker.stripExtraDelimiters(seg, seg.charAt(3)));
            }
            if (one.size() != two.size()) {
                log.info("Warning: inbound and parsed messages have different numbers of segments: \r\n");
                log.info("Original: " + originalMessageText + "\r\n");
                log.info("Parsed:   " + newMessageText + "\r\n");
            } else {
                int i = 0;
                while (i < one.size()) {
                    String newSeg;
                    String origSeg = (String)one.get(i);
                    if (!origSeg.equals(newSeg = (String)two.get(i))) {
                        log.info("Warning: inbound and parsed message segment differs: \r\n");
                        log.info("Original: " + origSeg + "\r\n");
                        log.info("Parsed: " + newSeg + "\r\n");
                    }
                    ++i;
                }
            }
        } else {
            log.info("No differences found\r\n");
        }
        log.info("********************  End Comparison  ******************\r\n");
    }

    private static String stripExtraDelimiters(String in, char delim) {
        char[] chars = in.toCharArray();
        int c = chars.length - 1;
        boolean found = false;
        while (c >= 0 && !found) {
            if (chars[c--] == delim) continue;
            found = true;
        }
        String ret = "";
        if (found) {
            ret = String.valueOf(chars, 0, c + 2);
        }
        return ret;
    }
}

