/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.validation.EncodingRule;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.PrimitiveTypeRule;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationContextImpl
implements ValidationContext,
Serializable {
    private List<RuleBinding> myPrimitiveRuleBindings = new ArrayList<RuleBinding>(30);
    private List<RuleBinding> myMessageRuleBindings = new ArrayList<RuleBinding>(20);
    private List<RuleBinding> myEncodingRuleBindings = new ArrayList<RuleBinding>(10);
    private boolean myCheckPrimitivesFlag = true;

    @Override
    public PrimitiveTypeRule[] getPrimitiveRules(String theVersion, String theTypeName, Primitive theType) {
        ArrayList<Rule> active = new ArrayList<Rule>(this.myPrimitiveRuleBindings.size());
        int i = 0;
        while (i < this.myPrimitiveRuleBindings.size()) {
            RuleBinding o = this.myPrimitiveRuleBindings.get(i);
            if (!(o instanceof RuleBinding)) {
                throw new ClassCastException("Item in rule binding list is not a RuleBinding");
            }
            RuleBinding binding = o;
            if (binding.getActive() && binding.appliesToVersion(theVersion) && binding.appliesToScope(theTypeName)) {
                active.add(binding.getRule());
            }
            ++i;
        }
        return active.toArray(new PrimitiveTypeRule[0]);
    }

    public List<RuleBinding> getPrimitiveRuleBindings() {
        return this.myPrimitiveRuleBindings;
    }

    @Override
    public MessageRule[] getMessageRules(String theVersion, String theMessageType, String theTriggerEvent) {
        ArrayList<Rule> active = new ArrayList<Rule>(this.myMessageRuleBindings.size());
        int i = 0;
        while (i < this.myMessageRuleBindings.size()) {
            RuleBinding o = this.myMessageRuleBindings.get(i);
            if (!(o instanceof RuleBinding)) {
                throw new ClassCastException("Item in rule binding list is not a RuleBinding");
            }
            RuleBinding binding = o;
            if (binding.getActive() && binding.appliesToVersion(theVersion) && binding.appliesToScope(String.valueOf(theMessageType) + "^" + theTriggerEvent)) {
                active.add(binding.getRule());
            }
            ++i;
        }
        return active.toArray(new MessageRule[0]);
    }

    public List<RuleBinding> getMessageRuleBindings() {
        return this.myMessageRuleBindings;
    }

    @Override
    public EncodingRule[] getEncodingRules(String theVersion, String theEncoding) {
        ArrayList<Rule> active = new ArrayList<Rule>(this.myEncodingRuleBindings.size());
        int i = 0;
        while (i < this.myEncodingRuleBindings.size()) {
            RuleBinding o = this.myEncodingRuleBindings.get(i);
            if (!(o instanceof RuleBinding)) {
                throw new ClassCastException("Item in rule binding list is not a RuleBinding");
            }
            RuleBinding binding = o;
            if (binding.getActive() && binding.appliesToVersion(theVersion) && binding.appliesToScope(theEncoding)) {
                active.add(binding.getRule());
            }
            ++i;
        }
        return active.toArray(new EncodingRule[0]);
    }

    public List<RuleBinding> getEncodingRuleBindings() {
        return this.myEncodingRuleBindings;
    }
}

