/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel;

import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.write.ExcelBuilder;
import com.alibaba.excel.write.ExcelBuilderImpl;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.excel.write.metadata.WriteWorkbook;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import java.util.Collection;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelWriter.class);
    private ExcelBuilder excelBuilder;

    public ExcelWriter(WriteWorkbook writeWorkbook) {
        this.excelBuilder = new ExcelBuilderImpl(writeWorkbook);
    }

    public ExcelWriter write(Collection<?> data, WriteSheet writeSheet) {
        return this.write(data, writeSheet, null);
    }

    public ExcelWriter write(Supplier<Collection<?>> supplier, WriteSheet writeSheet) {
        return this.write(supplier.get(), writeSheet, null);
    }

    public ExcelWriter write(Collection<?> data, WriteSheet writeSheet, WriteTable writeTable) {
        this.excelBuilder.addContent(data, writeSheet, writeTable);
        return this;
    }

    public ExcelWriter write(Supplier<Collection<?>> supplier, WriteSheet writeSheet, WriteTable writeTable) {
        this.excelBuilder.addContent(supplier.get(), writeSheet, writeTable);
        return this;
    }

    public ExcelWriter fill(Object data, WriteSheet writeSheet) {
        return this.fill(data, null, writeSheet);
    }

    public ExcelWriter fill(Object data, FillConfig fillConfig, WriteSheet writeSheet) {
        this.excelBuilder.fill(data, fillConfig, writeSheet);
        return this;
    }

    public ExcelWriter fill(Supplier<Object> supplier, WriteSheet writeSheet) {
        return this.fill(supplier.get(), null, writeSheet);
    }

    public ExcelWriter fill(Supplier<Object> supplier, FillConfig fillConfig, WriteSheet writeSheet) {
        this.excelBuilder.fill(supplier.get(), fillConfig, writeSheet);
        return this;
    }

    public void finish() {
        if (this.excelBuilder != null) {
            this.excelBuilder.finish(false);
        }
    }

    protected void finalize() {
        try {
            this.finish();
        }
        catch (Throwable e) {
            LOGGER.warn("Destroy object failed", e);
        }
    }

    public WriteContext writeContext() {
        return this.excelBuilder.writeContext();
    }
}

