/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.cache;

import com.alibaba.excel.cache.ReadCache;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.util.FileUtils;
import com.alibaba.excel.util.ListUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ehcache
implements ReadCache {
    private static final Logger log = LoggerFactory.getLogger(Ehcache.class);
    public static final int BATCH_COUNT = 100;
    private int activeIndex = 0;
    public static final int DEBUG_CACHE_MISS_SIZE = 1000;
    public static final int DEBUG_WRITE_SIZE = 1000000;
    private ArrayList<String> dataList = ListUtils.newArrayListWithExpectedSize(100);
    private static final CacheManager FILE_CACHE_MANAGER;
    private static final CacheConfiguration<Integer, ArrayList> FILE_CACHE_CONFIGURATION;
    private static final CacheManager ACTIVE_CACHE_MANAGER;
    private final CacheConfiguration<Integer, ArrayList> activeCacheConfiguration;
    private Cache<Integer, ArrayList> fileCache;
    private Cache<Integer, ArrayList> activeCache;
    private String cacheAlias;
    private int cacheMiss = 0;

    public Ehcache(int maxCacheActivateSize) {
        this.activeCacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(Integer.class, ArrayList.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap((long)maxCacheActivateSize, (ResourceUnit)MemoryUnit.MB)).withSizeOfMaxObjectGraph(1000000L).withSizeOfMaxObjectSize((long)maxCacheActivateSize, MemoryUnit.MB).build();
    }

    @Override
    public void init(AnalysisContext analysisContext) {
        this.cacheAlias = UUID.randomUUID().toString();
        this.fileCache = FILE_CACHE_MANAGER.createCache(this.cacheAlias, FILE_CACHE_CONFIGURATION);
        this.activeCache = ACTIVE_CACHE_MANAGER.createCache(this.cacheAlias, this.activeCacheConfiguration);
    }

    @Override
    public void put(String value) {
        int alreadyPut;
        this.dataList.add(value);
        if (this.dataList.size() >= 100) {
            this.fileCache.put((Object)this.activeIndex, this.dataList);
            ++this.activeIndex;
            this.dataList = ListUtils.newArrayListWithExpectedSize(100);
        }
        if (log.isDebugEnabled() && (alreadyPut = this.activeIndex * 100 + this.dataList.size()) % 1000000 == 0) {
            log.debug("Already put :{}", (Object)alreadyPut);
        }
    }

    @Override
    public String get(Integer key) {
        if (key == null || key < 0) {
            return null;
        }
        int route = key / 100;
        ArrayList dataList = (ArrayList)this.activeCache.get((Object)route);
        if (dataList == null) {
            dataList = (ArrayList)this.fileCache.get((Object)route);
            this.activeCache.put((Object)route, (Object)dataList);
            if (log.isDebugEnabled() && this.cacheMiss++ % 1000 == 0) {
                log.debug("Cache misses count:{}", (Object)this.cacheMiss);
            }
        }
        return (String)dataList.get(key % 100);
    }

    @Override
    public void putFinished() {
        if (CollectionUtils.isEmpty(this.dataList)) {
            return;
        }
        this.fileCache.put((Object)this.activeIndex, this.dataList);
    }

    @Override
    public void destroy() {
        FILE_CACHE_MANAGER.removeCache(this.cacheAlias);
        ACTIVE_CACHE_MANAGER.removeCache(this.cacheAlias);
    }

    static {
        File cacheFile = FileUtils.createCacheTmpFile();
        FILE_CACHE_MANAGER = CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((File)cacheFile)).build(true);
        ACTIVE_CACHE_MANAGER = CacheManagerBuilder.newCacheManagerBuilder().build(true);
        FILE_CACHE_CONFIGURATION = CacheConfigurationBuilder.newCacheConfigurationBuilder(Integer.class, ArrayList.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().disk(10L, MemoryUnit.GB)).withSizeOfMaxObjectGraph(1000000L).withSizeOfMaxObjectSize(10L, MemoryUnit.GB).build();
    }
}

