/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.builder;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.write.builder.AbstractExcelWriterParameterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import java.util.Collection;
import java.util.function.Supplier;

public class ExcelWriterTableBuilder
extends AbstractExcelWriterParameterBuilder<ExcelWriterTableBuilder, WriteTable> {
    private ExcelWriter excelWriter;
    private WriteSheet writeSheet;
    private WriteTable writeTable;

    public ExcelWriterTableBuilder() {
        this.writeTable = new WriteTable();
    }

    public ExcelWriterTableBuilder(ExcelWriter excelWriter, WriteSheet writeSheet) {
        this.excelWriter = excelWriter;
        this.writeSheet = writeSheet;
        this.writeTable = new WriteTable();
    }

    public ExcelWriterTableBuilder tableNo(Integer tableNo) {
        this.writeTable.setTableNo(tableNo);
        return this;
    }

    public WriteTable build() {
        return this.writeTable;
    }

    public void doWrite(Collection<?> data) {
        if (this.excelWriter == null) {
            throw new ExcelGenerateException("Must use 'EasyExcelFactory.write().sheet().table()' to call this method");
        }
        this.excelWriter.write(data, this.writeSheet, this.build());
        this.excelWriter.finish();
    }

    public void doWrite(Supplier<Collection<?>> supplier) {
        this.doWrite(supplier.get());
    }

    @Override
    protected WriteTable parameter() {
        return this.writeTable;
    }
}

