/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.channel.websocket;

import com.taobao.api.internal.toplink.Logger;
import com.taobao.api.internal.toplink.LoggerFactory;
import com.taobao.api.internal.toplink.Text;
import com.taobao.api.internal.toplink.channel.ChannelException;
import com.taobao.api.internal.toplink.channel.ClientChannel;
import com.taobao.api.internal.toplink.channel.ConnectingChannelHandler;
import com.taobao.api.internal.toplink.channel.netty.NettyClient;
import com.taobao.api.internal.toplink.channel.websocket.WebSocketClientChannel;
import com.taobao.api.internal.toplink.channel.websocket.WebSocketClientHelper;
import com.taobao.api.internal.toplink.channel.websocket.WebSocketClientUpstreamHandler;
import java.net.URI;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;

public class WebSocketClient
extends NettyClient {
    private static WebSocketClientHandshakerFactory wsFactory = new WebSocketClientHandshakerFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientChannel connect(LoggerFactory loggerFactory, URI uri, int connectTimeoutMillis) throws ChannelException {
        WebSocketClientUpstreamHandler wsHandler;
        ConnectingChannelHandler handler;
        WebSocketClientChannel clientChannel;
        block7: {
            Logger logger = loggerFactory.create(String.format("WebSocketClientHandler-%s", uri));
            clientChannel = new WebSocketClientChannel();
            clientChannel.setUri(uri);
            handler = new ConnectingChannelHandler();
            clientChannel.setChannelHandler(handler);
            wsHandler = new WebSocketClientUpstreamHandler(logger, clientChannel);
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
            pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
            Channel channel = WebSocketClient.prepareAndConnect(logger, uri, pipeline, (ChannelHandler)wsHandler, uri.getScheme().equalsIgnoreCase("wss"), connectTimeoutMillis);
            try {
                WebSocketClientHandshaker handshaker;
                wsHandler.handshaker = handshaker = wsFactory.newHandshaker(uri, WebSocketVersion.V13, null, true, WebSocketClientHelper.getHeaders(uri));
                handshaker.handshake(channel);
                if (wsHandler.handshaker.isHandshakeComplete() || handler.error != null) break block7;
                Object object = handler.syncObject;
                synchronized (object) {
                    handler.syncObject.wait(connectTimeoutMillis);
                }
            }
            catch (Exception e) {
                throw new ChannelException(Text.WS_HANDSHAKE_ERROR, e);
            }
        }
        if (wsHandler.handshaker.isHandshakeComplete()) {
            return clientChannel;
        }
        if (handler.error != null) {
            throw new ChannelException(Text.CONNECT_FAIL + ": " + handler.error.getMessage(), handler.error);
        }
        throw new ChannelException(Text.CONNECT_TIMEOUT);
    }
}

