/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ConditionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class QueryRequestMarshaller
implements Marshaller<Request<QueryRequest>, QueryRequest> {
    public Request<QueryRequest> marshall(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)queryRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.Query");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, AttributeValue> expressionAttributeValuesMap;
            Map<String, String> expressionAttributeNamesMap;
            Map<String, AttributeValue> exclusiveStartKeyMap;
            Map<String, Condition> queryFilterMap;
            Map<String, Condition> keyConditionsMap;
            List<String> attributesToGetList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (queryRequest.getTableName() != null) {
                jsonWriter.key("TableName").value((Object)queryRequest.getTableName());
            }
            if (queryRequest.getIndexName() != null) {
                jsonWriter.key("IndexName").value((Object)queryRequest.getIndexName());
            }
            if (queryRequest.getSelect() != null) {
                jsonWriter.key("Select").value((Object)queryRequest.getSelect());
            }
            if ((attributesToGetList = queryRequest.getAttributesToGet()) != null) {
                jsonWriter.key("AttributesToGet");
                jsonWriter.array();
                for (String attributesToGetListValue : attributesToGetList) {
                    if (attributesToGetListValue == null) continue;
                    jsonWriter.value((Object)attributesToGetListValue);
                }
                jsonWriter.endArray();
            }
            if (queryRequest.getLimit() != null) {
                jsonWriter.key("Limit").value((Object)queryRequest.getLimit());
            }
            if (queryRequest.getConsistentRead() != null) {
                jsonWriter.key("ConsistentRead").value((Object)queryRequest.getConsistentRead());
            }
            if ((keyConditionsMap = queryRequest.getKeyConditions()) != null) {
                jsonWriter.key("KeyConditions");
                jsonWriter.object();
                for (Map.Entry<String, Condition> keyConditionsMapValue : keyConditionsMap.entrySet()) {
                    if (keyConditionsMapValue.getValue() == null) continue;
                    jsonWriter.key(keyConditionsMapValue.getKey());
                    ConditionJsonMarshaller.getInstance().marshall(keyConditionsMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if ((queryFilterMap = queryRequest.getQueryFilter()) != null) {
                jsonWriter.key("QueryFilter");
                jsonWriter.object();
                for (Map.Entry<String, Condition> queryFilterMapValue : queryFilterMap.entrySet()) {
                    if (queryFilterMapValue.getValue() == null) continue;
                    jsonWriter.key(queryFilterMapValue.getKey());
                    ConditionJsonMarshaller.getInstance().marshall(queryFilterMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getConditionalOperator() != null) {
                jsonWriter.key("ConditionalOperator").value((Object)queryRequest.getConditionalOperator());
            }
            if (queryRequest.getScanIndexForward() != null) {
                jsonWriter.key("ScanIndexForward").value((Object)queryRequest.getScanIndexForward());
            }
            if ((exclusiveStartKeyMap = queryRequest.getExclusiveStartKey()) != null) {
                jsonWriter.key("ExclusiveStartKey");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> exclusiveStartKeyMapValue : exclusiveStartKeyMap.entrySet()) {
                    if (exclusiveStartKeyMapValue.getValue() == null) continue;
                    jsonWriter.key(exclusiveStartKeyMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(exclusiveStartKeyMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value((Object)queryRequest.getReturnConsumedCapacity());
            }
            if (queryRequest.getProjectionExpression() != null) {
                jsonWriter.key("ProjectionExpression").value((Object)queryRequest.getProjectionExpression());
            }
            if (queryRequest.getFilterExpression() != null) {
                jsonWriter.key("FilterExpression").value((Object)queryRequest.getFilterExpression());
            }
            if (queryRequest.getKeyConditionExpression() != null) {
                jsonWriter.key("KeyConditionExpression").value((Object)queryRequest.getKeyConditionExpression());
            }
            if ((expressionAttributeNamesMap = queryRequest.getExpressionAttributeNames()) != null) {
                jsonWriter.key("ExpressionAttributeNames");
                jsonWriter.object();
                for (Map.Entry<String, String> expressionAttributeNamesMapValue : expressionAttributeNamesMap.entrySet()) {
                    if (expressionAttributeNamesMapValue.getValue() == null) continue;
                    jsonWriter.key(expressionAttributeNamesMapValue.getKey());
                    jsonWriter.value((Object)expressionAttributeNamesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((expressionAttributeValuesMap = queryRequest.getExpressionAttributeValues()) != null) {
                jsonWriter.key("ExpressionAttributeValues");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> expressionAttributeValuesMapValue : expressionAttributeValuesMap.entrySet()) {
                    if (expressionAttributeValuesMapValue.getValue() == null) continue;
                    jsonWriter.key(expressionAttributeValuesMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(expressionAttributeValuesMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

