/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.StreamRecord;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class StreamRecordJsonMarshaller {
    private static StreamRecordJsonMarshaller instance;

    public void marshall(StreamRecord streamRecord, JSONWriter jsonWriter) {
        if (streamRecord == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, AttributeValue> oldImageMap;
            Map<String, AttributeValue> newImageMap;
            jsonWriter.object();
            Map<String, AttributeValue> keysMap = streamRecord.getKeys();
            if (keysMap != null) {
                jsonWriter.key("Keys");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> keysMapValue : keysMap.entrySet()) {
                    if (keysMapValue.getValue() == null) continue;
                    jsonWriter.key(keysMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(keysMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if ((newImageMap = streamRecord.getNewImage()) != null) {
                jsonWriter.key("NewImage");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> newImageMapValue : newImageMap.entrySet()) {
                    if (newImageMapValue.getValue() == null) continue;
                    jsonWriter.key(newImageMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(newImageMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if ((oldImageMap = streamRecord.getOldImage()) != null) {
                jsonWriter.key("OldImage");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> oldImageMapValue : oldImageMap.entrySet()) {
                    if (oldImageMapValue.getValue() == null) continue;
                    jsonWriter.key(oldImageMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(oldImageMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (streamRecord.getSequenceNumber() != null) {
                jsonWriter.key("SequenceNumber").value((Object)streamRecord.getSequenceNumber());
            }
            if (streamRecord.getSizeBytes() != null) {
                jsonWriter.key("SizeBytes").value((Object)streamRecord.getSizeBytes());
            }
            if (streamRecord.getStreamViewType() != null) {
                jsonWriter.key("StreamViewType").value((Object)streamRecord.getStreamViewType());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StreamRecordJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamRecordJsonMarshaller();
        }
        return instance;
    }
}

