/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecs.model.ListServicesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListServicesRequestMarshaller
implements Marshaller<Request<ListServicesRequest>, ListServicesRequest> {
    public Request<ListServicesRequest> marshall(ListServicesRequest listServicesRequest) {
        if (listServicesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listServicesRequest, "AmazonECS");
        String target = "AmazonEC2ContainerServiceV20141113.ListServices";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (listServicesRequest.getCluster() != null) {
                jsonWriter.key("cluster").value((Object)listServicesRequest.getCluster());
            }
            if (listServicesRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value((Object)listServicesRequest.getNextToken());
            }
            if (listServicesRequest.getMaxResults() != null) {
                jsonWriter.key("maxResults").value((Object)listServicesRequest.getMaxResults());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

