/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationFilter;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.transform.AssociationFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListAssociationsRequestMarshaller
implements Marshaller<Request<ListAssociationsRequest>, ListAssociationsRequest> {
    public Request<ListAssociationsRequest> marshall(ListAssociationsRequest listAssociationsRequest) {
        if (listAssociationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAssociationsRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.ListAssociations");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            SdkInternalList associationFilterListList = (SdkInternalList)listAssociationsRequest.getAssociationFilterList();
            if (!associationFilterListList.isEmpty() || !associationFilterListList.isAutoConstruct()) {
                jsonWriter.key("AssociationFilterList");
                jsonWriter.array();
                for (AssociationFilter associationFilterListListValue : associationFilterListList) {
                    if (associationFilterListListValue == null) continue;
                    AssociationFilterJsonMarshaller.getInstance().marshall(associationFilterListListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (listAssociationsRequest.getMaxResults() != null) {
                jsonWriter.key("MaxResults").value((Object)listAssociationsRequest.getMaxResults());
            }
            if (listAssociationsRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value((Object)listAssociationsRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

