/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongOpenHashSet
extends AbstractLongCollection
implements LongLookupContainer,
LongSet,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public long[] keys;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public LongOpenHashSet() {
        this(16, 0.75f);
    }

    public LongOpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongOpenHashSet(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public LongOpenHashSet(LongContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.addAll(container);
    }

    @Override
    public boolean add(long e) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(e, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (e == this.keys[slot]) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(e, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = e;
        }
        return true;
    }

    public int add(long e1, long e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(long ... elements) {
        int count = 0;
        for (long e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(LongContainer container) {
        return this.addAll((Iterable<? extends LongCursor>)container);
    }

    public int addAll(Iterable<? extends LongCursor> iterable) {
        int count = 0;
        for (LongCursor longCursor : iterable) {
            if (!this.add(longCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(long pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        long[] oldKeys = this.keys;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        long[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            long k = oldKeys[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
        }
    }

    private void allocateBuffers(int capacity) {
        long[] keys = new long[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public int removeAllOccurrences(long key) {
        return this.remove(key) ? 1 : 0;
    }

    public boolean remove(long key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        return this.lastSlot;
    }

    @Override
    public boolean contains(long key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, 0L);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        long[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = states.length;
        while (--i >= 0) {
            if (!states[i]) continue;
            h += Internals.rehash(keys[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            LongSet other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof LongSet && (other = (LongSet)obj).size() == this.size()) {
                for (LongCursor c : this) {
                    if (other.contains(c.value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<LongCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends LongProcedure> T forEach(T procedure) {
        long[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i]);
        }
        return procedure;
    }

    @Override
    public long[] toArray() {
        long[] cloned = new long[this.assigned];
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.allocated[i]) continue;
            cloned[j++] = this.keys[i];
        }
        return cloned;
    }

    public LongOpenHashSet clone() {
        try {
            LongOpenHashSet cloned = (LongOpenHashSet)super.clone();
            cloned.keys = (long[])this.keys.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends LongPredicate> T forEach(T predicate) {
        long[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length && (!states[i] || predicate.apply(keys[i])); ++i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        long[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int before = this.assigned;
        int i = 0;
        while (i < allocated.length) {
            if (allocated[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    public static LongOpenHashSet from(long ... elements) {
        LongOpenHashSet set = new LongOpenHashSet((int)((float)elements.length * 1.75f));
        set.add(elements);
        return set;
    }

    public static LongOpenHashSet from(LongContainer container) {
        return new LongOpenHashSet(container);
    }

    public static LongOpenHashSet newInstance() {
        return new LongOpenHashSet();
    }

    public static LongOpenHashSet newInstanceWithoutPerturbations() {
        return new LongOpenHashSet(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static LongOpenHashSet newInstanceWithCapacity(int initialCapacity, float loadFactor) {
        return new LongOpenHashSet(initialCapacity, loadFactor);
    }

    public static LongOpenHashSet newInstanceWithExpectedSize(int expectedSize) {
        return LongOpenHashSet.newInstanceWithExpectedSize(expectedSize, 0.75f);
    }

    public static LongOpenHashSet newInstanceWithExpectedSize(int expectedSize, float loadFactor) {
        return LongOpenHashSet.newInstanceWithCapacity((int)((float)expectedSize / loadFactor) + 1, loadFactor);
    }

    private final class EntryIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected LongCursor fetch() {
            int i;
            int max = LongOpenHashSet.this.keys.length;
            for (i = this.cursor.index + 1; i < LongOpenHashSet.this.keys.length && !LongOpenHashSet.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (LongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = LongOpenHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

