/*
 * Decompiled with CFR 0.152.
 */
package smile.data.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class IOUtils {
    private static String home = System.getProperty("smile.home", "shell/src/universal/");

    private IOUtils() {
    }

    public static String getTestDataPath(String path) {
        return home + "/data/" + path;
    }

    public static File getTestDataFile(String path) {
        return new File(IOUtils.getTestDataPath(path));
    }

    public static BufferedReader getTestDataReader(String path) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader(new FileInputStream(IOUtils.getTestDataFile(path))));
    }

    public static List<String> readLines(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(InputStream input, Charset charset) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, charset);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        reader.close();
        return list;
    }
}

