/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import smile.math.Math;
import smile.math.random.MersenneTwister;
import smile.math.random.UniversalGenerator;

public class Random {
    private UniversalGenerator real;
    private MersenneTwister twister;

    public Random() {
        this.real = new UniversalGenerator();
        this.twister = new MersenneTwister();
    }

    public Random(long seed) {
        this.real = new UniversalGenerator(seed);
        this.twister = new MersenneTwister(seed);
    }

    public double nextDouble() {
        return this.real.nextDouble();
    }

    public void nextDoubles(double[] d) {
        this.real.nextDoubles(d);
    }

    public double nextDouble(double lo, double hi) {
        return lo + (hi - lo) * this.nextDouble();
    }

    public void nextDoubles(double[] d, double lo, double hi) {
        this.real.nextDoubles(d);
        double l = hi - lo;
        int n = d.length;
        for (int i = 0; i < n; ++i) {
            d[i] = lo + l * d[i];
        }
    }

    public void setSeed(long seed) {
        this.real.setSeed(seed);
        this.twister.setSeed(seed);
    }

    public int nextInt() {
        return this.twister.nextInt();
    }

    public int nextInt(int n) {
        return this.twister.nextInt(n);
    }

    public long nextLong() {
        return this.twister.nextLong();
    }

    public int[] permutate(int n) {
        int[] x = new int[n];
        for (int i = 0; i < n; ++i) {
            x[i] = i;
        }
        this.permutate(x);
        return x;
    }

    public void permutate(int[] x) {
        for (int i = 0; i < x.length; ++i) {
            int j = i + this.nextInt(x.length - i);
            Math.swap(x, i, j);
        }
    }

    public void permutate(float[] x) {
        for (int i = 0; i < x.length; ++i) {
            int j = i + this.nextInt(x.length - i);
            Math.swap(x, i, j);
        }
    }

    public void permutate(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            int j = i + this.nextInt(x.length - i);
            Math.swap(x, i, j);
        }
    }

    public void permutate(Object[] x) {
        for (int i = 0; i < x.length; ++i) {
            int j = i + this.nextInt(x.length - i);
            Math.swap(x, i, j);
        }
    }
}

