/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

import smile.sort.SortUtils;

public class QuickSelect {
    private QuickSelect() {
    }

    public static int select(int[] arr, int k) {
        int n = arr.length;
        int l = 0;
        int ir = n - 1;
        while (true) {
            if (ir <= l + 1) {
                if (ir == l + 1 && arr[ir] < arr[l]) {
                    SortUtils.swap(arr, l, ir);
                }
                return arr[k];
            }
            int mid = l + ir >> 1;
            SortUtils.swap(arr, mid, l + 1);
            if (arr[l] > arr[ir]) {
                SortUtils.swap(arr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                SortUtils.swap(arr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                SortUtils.swap(arr, l, l + 1);
            }
            int i = l + 1;
            int j = ir;
            int a = arr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            if (j >= k) {
                ir = j - 1;
            }
            if (j > k) continue;
            l = i;
        }
    }

    public static float select(float[] arr, int k) {
        int n = arr.length;
        int l = 0;
        int ir = n - 1;
        while (true) {
            if (ir <= l + 1) {
                if (ir == l + 1 && arr[ir] < arr[l]) {
                    SortUtils.swap(arr, l, ir);
                }
                return arr[k];
            }
            int mid = l + ir >> 1;
            SortUtils.swap(arr, mid, l + 1);
            if (arr[l] > arr[ir]) {
                SortUtils.swap(arr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                SortUtils.swap(arr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                SortUtils.swap(arr, l, l + 1);
            }
            int i = l + 1;
            int j = ir;
            float a = arr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            if (j >= k) {
                ir = j - 1;
            }
            if (j > k) continue;
            l = i;
        }
    }

    public static double select(double[] arr, int k) {
        int n = arr.length;
        int l = 0;
        int ir = n - 1;
        while (true) {
            if (ir <= l + 1) {
                if (ir == l + 1 && arr[ir] < arr[l]) {
                    SortUtils.swap(arr, l, ir);
                }
                return arr[k];
            }
            int mid = l + ir >> 1;
            SortUtils.swap(arr, mid, l + 1);
            if (arr[l] > arr[ir]) {
                SortUtils.swap(arr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                SortUtils.swap(arr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                SortUtils.swap(arr, l, l + 1);
            }
            int i = l + 1;
            int j = ir;
            double a = arr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            if (j >= k) {
                ir = j - 1;
            }
            if (j > k) continue;
            l = i;
        }
    }

    public static <T extends Comparable<? super T>> T select(T[] arr, int k) {
        int n = arr.length;
        int l = 0;
        int ir = n - 1;
        while (true) {
            if (ir <= l + 1) {
                if (ir == l + 1 && arr[ir].compareTo(arr[l]) < 0) {
                    SortUtils.swap(arr, l, ir);
                }
                return arr[k];
            }
            int mid = l + ir >> 1;
            SortUtils.swap(arr, mid, l + 1);
            if (arr[l].compareTo(arr[ir]) > 0) {
                SortUtils.swap(arr, l, ir);
            }
            if (arr[l + 1].compareTo(arr[ir]) > 0) {
                SortUtils.swap(arr, l + 1, ir);
            }
            if (arr[l].compareTo(arr[l + 1]) > 0) {
                SortUtils.swap(arr, l, l + 1);
            }
            int i = l + 1;
            int j = ir;
            T a = arr[l + 1];
            while (true) {
                if (arr[++i].compareTo(a) < 0) {
                    continue;
                }
                while (arr[--j].compareTo(a) > 0) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            if (j >= k) {
                ir = j - 1;
            }
            if (j > k) continue;
            l = i;
        }
    }

    public static int median(int[] a) {
        int k = a.length / 2;
        return QuickSelect.select(a, k);
    }

    public static float median(float[] a) {
        int k = a.length / 2;
        return QuickSelect.select(a, k);
    }

    public static double median(double[] a) {
        int k = a.length / 2;
        return QuickSelect.select(a, k);
    }

    public static <T extends Comparable<? super T>> T median(T[] a) {
        int k = a.length / 2;
        return (T)QuickSelect.select(a, (int)k);
    }

    public static int q1(int[] a) {
        int k = a.length / 4;
        return QuickSelect.select(a, k);
    }

    public static float q1(float[] a) {
        int k = a.length / 4;
        return QuickSelect.select(a, k);
    }

    public static double q1(double[] a) {
        int k = a.length / 4;
        return QuickSelect.select(a, k);
    }

    public static <T extends Comparable<? super T>> T q1(T[] a) {
        int k = a.length / 4;
        return (T)QuickSelect.select(a, (int)k);
    }

    public static int q3(int[] a) {
        int k = 3 * a.length / 4;
        return QuickSelect.select(a, k);
    }

    public static float q3(float[] a) {
        int k = 3 * a.length / 4;
        return QuickSelect.select(a, k);
    }

    public static double q3(double[] a) {
        int k = 3 * a.length / 4;
        return QuickSelect.select(a, k);
    }

    public static <T extends Comparable<? super T>> T q3(T[] a) {
        int k = 3 * a.length / 4;
        return (T)QuickSelect.select(a, (int)k);
    }
}

