/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import java.io.IOException;
import org.apache.commons.lang3.Validate;

public class EmbeddedHelper
implements Helper<String> {
    public static final Helper<String> INSTANCE = new EmbeddedHelper();
    public static final String NAME = "embedded";

    @Override
    public Object apply(String path, Options options) throws IOException {
        Validate.notEmpty((CharSequence)path, (String)"found '%s', expected 'partial's name'", (Object[])new Object[]{path});
        String suffix = options.handlebars.getLoader().getSuffix();
        String defaultId = (path + suffix).replace('/', '-').replace('.', '-');
        String id = options.param(0, defaultId);
        Template template = options.handlebars.compile(path);
        StringBuilder script = new StringBuilder();
        script.append("<script id=\"").append(id).append("\" type=\"text/x-handlebars\">\n");
        script.append(template.text()).append("\n");
        script.append("</script>");
        return new Handlebars.SafeString(script);
    }
}

