/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import java.util.Set;
import java.util.regex.Pattern;
import wiremock.com.google.common.collect.ImmutableSet;

public class SystemKeyAuthoriser {
    private final ImmutableSet<Pattern> regexes;

    public SystemKeyAuthoriser(Set<String> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            patterns = ImmutableSet.of("wiremock.*");
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String pattern : patterns) {
            builder.add(Pattern.compile(pattern, 2));
        }
        this.regexes = builder.build();
    }

    public boolean isPermitted(String key) {
        for (Pattern regex : this.regexes) {
            if (!regex.matcher(key).matches()) continue;
            return true;
        }
        return false;
    }
}

