/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.ssl;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.ssl.CertChainAndKey;
import com.github.tomakehurst.wiremock.http.ssl.CertificateAuthority;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class X509KeyStore {
    private final KeyStore keyStore;
    private final char[] password;
    private final List<String> aliases;

    public X509KeyStore(KeyStore keyStore, char[] password) throws KeyStoreException {
        this.keyStore = Objects.requireNonNull(keyStore);
        this.password = Objects.requireNonNull(password);
        this.aliases = Collections.list(keyStore.aliases());
    }

    PrivateKey getPrivateKey(String alias) {
        try {
            Key key = this.keyStore.getKey(alias, this.password);
            if (key instanceof PrivateKey) {
                return (PrivateKey)key;
            }
            return null;
        }
        catch (NoSuchAlgorithmException | UnrecoverableKeyException e) {
            return null;
        }
        catch (KeyStoreException e) {
            return (PrivateKey)Exceptions.throwUnchecked(e, null);
        }
    }

    X509Certificate[] getCertificateChain(String alias) {
        try {
            Certificate[] fromKeyStore = this.keyStore.getCertificateChain(alias);
            if (fromKeyStore != null && X509KeyStore.areX509Certificates(fromKeyStore)) {
                return X509KeyStore.convertToX509(fromKeyStore);
            }
            return null;
        }
        catch (KeyStoreException e) {
            return (X509Certificate[])Exceptions.throwUnchecked(e, null);
        }
    }

    private static boolean areX509Certificates(Certificate[] fromKeyStore) {
        return fromKeyStore.length == 0 || fromKeyStore[0] instanceof X509Certificate;
    }

    private static X509Certificate[] convertToX509(Certificate[] fromKeyStore) {
        return (X509Certificate[])Arrays.stream(fromKeyStore).map(X509Certificate.class::cast).toArray(X509Certificate[]::new);
    }

    public CertificateAuthority getCertificateAuthority() {
        for (String alias : this.aliases) {
            X509Certificate[] chain = this.getCertificateChain(alias);
            PrivateKey key = this.getPrivateKey(alias);
            if (!X509KeyStore.isCertificateAuthority(chain[0]) || key == null) continue;
            return new CertificateAuthority(chain, key);
        }
        return null;
    }

    private static boolean isCertificateAuthority(X509Certificate certificate) {
        boolean[] keyUsage = certificate.getKeyUsage();
        return keyUsage != null && keyUsage.length > 5 && keyUsage[5];
    }

    void setKeyEntry(String alias, CertChainAndKey newCertChainAndKey) throws KeyStoreException {
        this.keyStore.setKeyEntry(alias, newCertChainAndKey.key, this.password, newCertChainAndKey.certificateChain);
    }
}

