/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.xml;

import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.xml.XPathException;
import com.github.tomakehurst.wiremock.common.xml.XmlNode;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xmlunit.util.Convert;

public class XmlDocument
extends XmlNode {
    private final Document document;

    public XmlDocument(Document document) {
        super(document);
        this.document = document;
    }

    public ListOrSingle<XmlNode> findNodes(String xPathExpression) {
        return this.findNodes(xPathExpression, null);
    }

    public ListOrSingle<XmlNode> findNodes(String xPathExpression, Map<String, String> namespaces) {
        try {
            NodeList nodeSet;
            XPath xPath = (XPath)XPATH_CACHE.get();
            xPath.reset();
            if (namespaces != null) {
                Map<String, String> fullNamespaces = XmlDocument.addStandardNamespaces(namespaces);
                NamespaceContext namespaceContext = Convert.toNamespaceContext(fullNamespaces);
                xPath.setNamespaceContext(namespaceContext);
                nodeSet = (NodeList)xPath.evaluate(xPathExpression, Convert.toInputSource((Source)new DOMSource(this.document)), XPathConstants.NODESET);
            } else {
                nodeSet = (NodeList)xPath.evaluate(xPathExpression, this.document, XPathConstants.NODESET);
            }
            return XmlDocument.toListOrSingle(nodeSet);
        }
        catch (XPathExpressionException e) {
            throw XPathException.fromXPathException(e);
        }
    }

    private static Map<String, String> addStandardNamespaces(Map<String, String> namespaces) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String prefix : namespaces.keySet()) {
            String uri = namespaces.get(prefix);
            if ("http://www.w3.org/XML/1998/namespace".equals(uri) || "http://www.w3.org/2000/xmlns/".equals(uri)) continue;
            result.put(prefix, uri);
        }
        result.put("xml", "http://www.w3.org/XML/1998/namespace");
        result.put("xmlns", "http://www.w3.org/2000/xmlns/");
        return result;
    }
}

