/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.StubServer;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.PostServeAction;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilter;
import com.github.tomakehurst.wiremock.http.AbstractRequestHandler;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import java.util.List;
import java.util.Map;

public class StubRequestHandler
extends AbstractRequestHandler {
    private final StubServer stubServer;
    private final Admin admin;
    private final Map<String, PostServeAction> postServeActions;
    private final RequestJournal requestJournal;
    private final boolean loggingDisabled;

    public StubRequestHandler(StubServer stubServer, ResponseRenderer responseRenderer, Admin admin, Map<String, PostServeAction> postServeActions, RequestJournal requestJournal, List<RequestFilter> requestFilters, boolean loggingDisabled) {
        super(responseRenderer, requestFilters);
        this.stubServer = stubServer;
        this.admin = admin;
        this.postServeActions = postServeActions;
        this.requestJournal = requestJournal;
        this.loggingDisabled = loggingDisabled;
    }

    @Override
    public ServeEvent handleRequest(Request request) {
        return this.stubServer.serveStubFor(request);
    }

    @Override
    protected boolean logRequests() {
        return !this.loggingDisabled;
    }

    @Override
    protected void beforeResponseSent(ServeEvent serveEvent, Response response) {
        this.requestJournal.requestReceived(serveEvent);
    }

    @Override
    protected void afterResponseSent(ServeEvent serveEvent, Response response) {
        for (PostServeAction postServeAction : this.postServeActions.values()) {
            postServeAction.doGlobalAction(serveEvent, this.admin);
        }
        Map<String, Parameters> postServeActionRefs = serveEvent.getPostServeActions();
        for (Map.Entry<String, Parameters> postServeActionEntry : postServeActionRefs.entrySet()) {
            PostServeAction action = this.postServeActions.get(postServeActionEntry.getKey());
            if (action != null) {
                Parameters parameters = postServeActionEntry.getValue();
                action.doAction(serveEvent, this.admin, parameters);
                continue;
            }
            LocalNotifier.notifier().error("No extension was found named \"" + postServeActionEntry.getKey() + "\"");
        }
    }
}

