/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.github.tomakehurst.wiremock.common.KeyStoreSettings;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.LinkedList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;

public class ProxyResponseRenderer
implements ResponseRenderer {
    private static final int MINUTES = 60000;
    private static final String TRANSFER_ENCODING = "transfer-encoding";
    private static final String CONTENT_LENGTH = "content-length";
    private static final String HOST_HEADER = "host";
    private final HttpClient client;
    private final boolean preserveHostHeader;
    private final String hostHeaderValue;

    public ProxyResponseRenderer(ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean preserveHostHeader, String hostHeaderValue) {
        this.client = HttpClientFactory.createClient(1000, 300000, proxySettings, trustStoreSettings);
        this.preserveHostHeader = preserveHostHeader;
        this.hostHeaderValue = hostHeaderValue;
    }

    public ProxyResponseRenderer() {
        this(ProxySettings.NO_PROXY, KeyStoreSettings.NO_STORE, false, null);
    }

    @Override
    public Response render(ResponseDefinition responseDefinition) {
        HttpUriRequest httpRequest = ProxyResponseRenderer.getHttpRequestFor(responseDefinition);
        this.addRequestHeaders((HttpRequest)httpRequest, responseDefinition);
        try {
            ProxyResponseRenderer.addBodyIfPostPutOrPatch((HttpRequest)httpRequest, responseDefinition);
            HttpResponse httpResponse = this.client.execute(httpRequest);
            return Response.response().status(httpResponse.getStatusLine().getStatusCode()).headers(this.headersFrom(httpResponse, responseDefinition)).body(HttpClientUtils.getEntityAsByteArrayAndCloseStream(httpResponse)).fromProxy(true).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpHeaders headersFrom(HttpResponse httpResponse, ResponseDefinition responseDefinition) {
        LinkedList<HttpHeader> httpHeaders = new LinkedList<HttpHeader>();
        for (Header header : httpResponse.getAllHeaders()) {
            httpHeaders.add(new HttpHeader(header.getName(), header.getValue()));
        }
        if (responseDefinition.getHeaders() != null) {
            httpHeaders.addAll(responseDefinition.getHeaders().all());
        }
        return new HttpHeaders(httpHeaders);
    }

    private static HttpUriRequest getHttpRequestFor(ResponseDefinition response) {
        RequestMethod method = response.getOriginalRequest().getMethod();
        String url = response.getProxyUrl();
        LocalNotifier.notifier().info("Proxying: " + (Object)((Object)method) + " " + url);
        switch (method) {
            case GET: {
                return new HttpGet(url);
            }
            case POST: {
                return new HttpPost(url);
            }
            case PUT: {
                return new HttpPut(url);
            }
            case DELETE: {
                return new HttpDelete(url);
            }
            case HEAD: {
                return new HttpHead(url);
            }
            case OPTIONS: {
                return new HttpOptions(url);
            }
            case TRACE: {
                return new HttpTrace(url);
            }
            case PATCH: {
                return new HttpPatch(url);
            }
        }
        throw new RuntimeException("Cannot create HttpMethod for " + (Object)((Object)method));
    }

    private void addRequestHeaders(HttpRequest httpRequest, ResponseDefinition response) {
        Request originalRequest = response.getOriginalRequest();
        for (String key : originalRequest.getAllHeaderKeys()) {
            if (!ProxyResponseRenderer.headerShouldBeTransferred(key)) continue;
            if (!HOST_HEADER.equalsIgnoreCase(key) || this.preserveHostHeader) {
                String value = originalRequest.getHeader(key);
                httpRequest.addHeader(key, value);
                continue;
            }
            if (this.hostHeaderValue != null) {
                httpRequest.addHeader(key, this.hostHeaderValue);
                continue;
            }
            if (response.getProxyBaseUrl() == null) continue;
            httpRequest.addHeader(key, URI.create(response.getProxyBaseUrl()).getHost());
        }
        if (response.getAdditionalProxyRequestHeaders() != null) {
            for (String key : response.getAdditionalProxyRequestHeaders().keys()) {
                httpRequest.setHeader(key, response.getAdditionalProxyRequestHeaders().getHeader(key).firstValue());
            }
        }
    }

    private static boolean headerShouldBeTransferred(String key) {
        return !ImmutableList.of((Object)CONTENT_LENGTH, (Object)TRANSFER_ENCODING, (Object)"connection").contains((Object)key.toLowerCase());
    }

    private static void addBodyIfPostPutOrPatch(HttpRequest httpRequest, ResponseDefinition response) throws UnsupportedEncodingException {
        Request originalRequest = response.getOriginalRequest();
        if (originalRequest.getMethod().isOneOf(RequestMethod.PUT, RequestMethod.POST, RequestMethod.PATCH)) {
            HttpEntityEnclosingRequest requestWithEntity = (HttpEntityEnclosingRequest)httpRequest;
            requestWithEntity.setEntity(ProxyResponseRenderer.buildEntityFrom(originalRequest));
        }
    }

    private static HttpEntity buildEntityFrom(Request originalRequest) {
        ContentTypeHeader contentTypeHeader = originalRequest.contentTypeHeader().or("text/plain");
        ContentType contentType = ContentType.create((String)contentTypeHeader.mimeTypePart(), (String)((String)contentTypeHeader.encodingPart().or((Object)"utf-8")));
        if (originalRequest.containsHeader(TRANSFER_ENCODING) && originalRequest.header(TRANSFER_ENCODING).firstValue().equals("chunked")) {
            return new InputStreamEntity((InputStream)new ByteArrayInputStream(originalRequest.getBodyAsString().getBytes()), -1L, contentType);
        }
        return new StringEntity(originalRequest.getBodyAsString(), contentType);
    }
}

