/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.factory.primitive;

import com.gs.collections.api.factory.set.primitive.ImmutableShortSetFactory;
import com.gs.collections.api.factory.set.primitive.MutableShortSetFactory;
import com.gs.collections.impl.set.immutable.primitive.ImmutableShortSetFactoryImpl;
import com.gs.collections.impl.set.mutable.primitive.MutableShortSetFactoryImpl;

/**
 * ShortSets is a static utility for creating {@link ImmutableShortSetFactory}.
 * This file was automatically generated from template file primitiveSets.stg.
 *
 * @since 3.2.
 */
@SuppressWarnings("ConstantNamingConvention")
public final class ShortSets
{
    public static final ImmutableShortSetFactory immutable = new ImmutableShortSetFactoryImpl();
    public static final MutableShortSetFactory mutable = new MutableShortSetFactoryImpl();

    private ShortSets()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
