/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.factory.list.primitive.MutableShortListFactory;
import com.gs.collections.api.list.primitive.MutableShortList;

/**
 * MutableShortListFactoryImpl is a factory implementation which creates instances of type {@link MutableShortList}.
 * This file was automatically generated from template file mutablePrimitiveListFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableShortListFactoryImpl implements MutableShortListFactory
{
    public MutableShortList empty()
    {
        return new ShortArrayList();
    }

    public MutableShortList of()
    {
        return this.empty();
    }

    public MutableShortList with()
    {
        return this.empty();
    }

    public MutableShortList of(short... items)
    {
        return this.with(items);
    }

    public MutableShortList with(short... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return ShortArrayList.newListWith(items);
    }

    public MutableShortList ofAll(ShortIterable items)
    {
        return this.withAll(items);
    }

    public MutableShortList withAll(ShortIterable items)
    {
        return ShortArrayList.newList(items);
    }
}
