/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteIntProcedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.ByteList;
import com.gs.collections.api.list.primitive.ImmutableByteList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableByteCollection;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseByteIterable;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveList.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableByteList
        extends AbstractUnmodifiableByteCollection
        implements MutableByteList
{
    private static final long serialVersionUID = 1L;

    UnmodifiableByteList(MutableByteList list)
    {
        super(list);
    }

    private MutableByteList getMutableByteList()
    {
        return (MutableByteList) this.getByteCollection();
    }

    public byte get(int index)
    {
        return this.getMutableByteList().get(index);
    }

    public byte getFirst()
    {
        return this.getMutableByteList().getFirst();
    }

    public byte getLast()
    {
        return this.getMutableByteList().getLast();
    }

    public int indexOf(byte value)
    {
        return this.getMutableByteList().indexOf(value);
    }

    public int lastIndexOf(byte value)
    {
        return this.getMutableByteList().lastIndexOf(value);
    }

    public void addAtIndex(int index, byte element)
    {
        throw new UnsupportedOperationException("Cannot call addAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean addAllAtIndex(int index, byte... source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean addAllAtIndex(int index, ByteIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex() on " + this.getClass().getSimpleName());
    }

    public byte removeAtIndex(int index)
    {
        throw new UnsupportedOperationException("Cannot call removeAtIndex() on " + this.getClass().getSimpleName());
    }

    public byte set(int index, byte element)
    {
        throw new UnsupportedOperationException("Cannot call set() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableByteList with(byte element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableByteList without(byte element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableByteList withAll(ByteIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableByteList withoutAll(ByteIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableByteList select(BytePredicate predicate)
    {
        return this.getMutableByteList().select(predicate);
    }

    @Override
    public MutableByteList reject(BytePredicate predicate)
    {
        return this.getMutableByteList().reject(predicate);
    }

    @Override
    public <V> MutableList<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return this.getMutableByteList().collect(function);
    }

    public MutableByteList sortThis()
    {
        throw new UnsupportedOperationException("Cannot call sortThis() on " + this.getClass().getSimpleName());
    }

    public long dotProduct(ByteList list)
    {
        return this.getMutableByteList().dotProduct(list);
    }

    @Override
    public boolean equals(Object otherList)
    {
        return this.getMutableByteList().equals(otherList);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableByteList().hashCode();
    }

    @Override
    public MutableByteList asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableByteList asSynchronized()
    {
        return new SynchronizedByteList(this);
    }

    @Override
    public ImmutableByteList toImmutable()
    {
        int size = this.size();
        if (size == 0)
        {
            return ByteLists.immutable.with();
        }
        if (size == 1)
        {
            return ByteLists.immutable.with(this.getFirst());
        }
        return ByteLists.immutable.with(this.toArray());
    }

    public MutableByteList reverseThis()
    {
        throw new UnsupportedOperationException("Cannot call reverseThis() on " + this.getClass().getSimpleName());
    }

    public MutableByteList toReversed()
    {
        return this.getMutableByteList().toReversed();
    }

    public void forEachWithIndex(ByteIntProcedure procedure)
    {
        this.getMutableByteList().forEachWithIndex(procedure);
    }

    public LazyByteIterable asReversed()
    {
        return ReverseByteIterable.adapt(this);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectByteIntToObjectFunction<? super T, ? extends T> function)
    {
        return this.getMutableByteList().injectIntoWithIndex(injectedValue, function);
    }

    /**
     * @since 6.0.
     */
    public MutableByteList distinct()
    {
        return this.getMutableByteList().distinct();
    }

    public MutableByteList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
