/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleCharPredicate;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleCharProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.DoubleCharMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleCharMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.tuple.primitive.DoubleCharPair;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.iterator.ImmutableEmptyCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.primitive.LazyDoubleIterate;

/**
 * ImmutableDoubleCharEmptyMap is an optimization for {@link ImmutableDoubleCharMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableDoubleCharEmptyMap implements ImmutableDoubleCharMap, Serializable
{
    static final ImmutableDoubleCharMap INSTANCE = new ImmutableDoubleCharEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\0';

    private Object readResolve()
    {
        return INSTANCE;
    }

    public char get(double key)
    {
        return EMPTY_VALUE;
    }

    public char getIfAbsent(double key, char ifAbsent)
    {
        return ifAbsent;
    }

    public char getOrThrow(double key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(double key)
    {
        return false;
    }

    public boolean containsValue(char value)
    {
        return false;
    }

    public void forEachValue(CharProcedure procedure)
    {
    }

    public void forEachKey(DoubleProcedure procedure)
    {
    }

    public void forEachKeyValue(DoubleCharProcedure procedure)
    {
    }

    public LazyDoubleIterable keysView()
    {
        return LazyDoubleIterate.empty();
    }

    public RichIterable<DoubleCharPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableDoubleCharMap select(DoubleCharPredicate predicate)
    {
        return this;
    }

    public ImmutableDoubleCharMap reject(DoubleCharPredicate predicate)
    {
        return this;
    }

    public ImmutableDoubleCharMap toImmutable()
    {
        return this;
    }

    public CharIterator charIterator()
    {
        return ImmutableEmptyCharIterator.INSTANCE;
    }

    public void forEach(CharProcedure procedure)
    {
    }

    public int count(CharPredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public char min()
    {
        throw new NoSuchElementException();
    }

    public char max()
    {
        throw new NoSuchElementException();
    }

    public char maxIfEmpty(char defaultValue)
    {
        return defaultValue;
    }

    public char minIfEmpty(char defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public char[] toSortedArray()
    {
        return new char[0];
    }

    public MutableCharList toSortedList()
    {
        return new CharArrayList();
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return true;
    }

    public ImmutableCharCollection select(CharPredicate predicate)
    {
        return CharLists.immutable.with();
    }

    public ImmutableCharCollection reject(CharPredicate predicate)
    {
        return CharLists.immutable.with();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public char[] toArray()
    {
        return new char[0];
    }

    public boolean contains(char value)
    {
        return false;
    }

    public boolean containsAll(char... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(CharIterable source)
    {
        return source.isEmpty();
    }

    public MutableCharList toList()
    {
        return new CharArrayList();
    }

    public MutableCharSet toSet()
    {
        return new CharHashSet();
    }

    public MutableCharBag toBag()
    {
        return new CharHashBag();
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public ImmutableDoubleCharMap newWithKeyValue(double key, char value)
    {
        return new ImmutableDoubleCharSingletonMap(key, value);
    }

    public ImmutableDoubleCharMap newWithoutKey(double key)
    {
        return this;
    }

    public ImmutableDoubleCharMap newWithoutAllKeys(DoubleIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableDoubleSet keySet()
    {
        return UnmodifiableDoubleSet.of(new DoubleHashSet());
    }

    public MutableCharCollection values()
    {
        return UnmodifiableCharCollection.of(new CharArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof DoubleCharMap))
        {
            return false;
        }
        DoubleCharMap map = (DoubleCharMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
