/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.primitive.AbstractCharSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableCharSet extends AbstractCharSet implements ImmutableCharSet
{
    public ImmutableCharSet newWith(char element)
    {
        return CharHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableCharSet newWithout(char element)
    {
        return CharHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableCharSet newWithAll(CharIterable elements)
    {
        return CharHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableCharSet newWithoutAll(CharIterable elements)
    {
        return CharHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public CharSet freeze()
    {
        return this;
    }

    public ImmutableCharSet toImmutable()
    {
        return this;
    }
}
