/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.set.primitive.ImmutableDoubleSet;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.primitive.AbstractDoubleSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableDoubleSet extends AbstractDoubleSet implements ImmutableDoubleSet
{
    public ImmutableDoubleSet newWith(double element)
    {
        return DoubleHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableDoubleSet newWithout(double element)
    {
        return DoubleHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableDoubleSet newWithAll(DoubleIterable elements)
    {
        return DoubleHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableDoubleSet newWithoutAll(DoubleIterable elements)
    {
        return DoubleHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public DoubleSet freeze()
    {
        return this;
    }

    public ImmutableDoubleSet toImmutable()
    {
        return this;
    }
}
