/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.primitive.AbstractIntSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableIntSet extends AbstractIntSet implements ImmutableIntSet
{
    public ImmutableIntSet newWith(int element)
    {
        return IntHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableIntSet newWithout(int element)
    {
        return IntHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableIntSet newWithAll(IntIterable elements)
    {
        return IntHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableIntSet newWithoutAll(IntIterable elements)
    {
        return IntHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public IntSet freeze()
    {
        return this;
    }

    public ImmutableIntSet toImmutable()
    {
        return this;
    }
}
