/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.factory.stack.primitive.MutableIntStackFactory;
import com.gs.collections.api.stack.primitive.MutableIntStack;

/**
 * MutableIntStackFactoryImpl is a factory implementation which creates instances of type {@link MutableIntStack}.
 * This file was automatically generated from template file mutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableIntStackFactoryImpl implements MutableIntStackFactory
{
    public MutableIntStack empty()
    {
        return new IntArrayStack();
    }

    public MutableIntStack of()
    {
        return this.empty();
    }

    public MutableIntStack with()
    {
        return this.empty();
    }

    public MutableIntStack of(int... items)
    {
        return this.with(items);
    }

    public MutableIntStack with(int... items)
    {
        if (items.length == 0)
        {
            return this.empty();
        }
        return IntArrayStack.newStackWith(items);
    }

    public MutableIntStack ofAll(IntIterable items)
    {
        return this.withAll(items);
    }

    public MutableIntStack withAll(IntIterable items)
    {
        if (items.isEmpty())
        {
            return this.empty();
        }
        return IntArrayStack.newStack(items);
    }

    public MutableIntStack ofAllReversed(IntIterable items)
    {
        return this.withAllReversed(items);
    }

    public MutableIntStack withAllReversed(IntIterable items)
    {
        if (items.isEmpty())
        {
            return this.empty();
        }
        return IntArrayStack.newStackFromTopToBottom(items);
    }
}
