/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.FloatBag;
import com.gs.collections.api.bag.primitive.ImmutableFloatBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatIntProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.iterator.MutableFloatIterator;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.impl.Counter;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.SynchronizedFloatBag;
import com.gs.collections.impl.bag.mutable.primitive.UnmodifiableFloatBag;
import com.gs.collections.impl.block.factory.primitive.IntToIntFunctions;
import com.gs.collections.impl.factory.primitive.FloatBags;
import com.gs.collections.impl.map.mutable.primitive.FloatIntHashMap;
import com.gs.collections.impl.primitive.AbstractFloatIterable;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class FloatHashBag
extends AbstractFloatIterable
implements MutableFloatBag,
Externalizable {
    private static final long serialVersionUID = 1L;
    private FloatIntHashMap items;
    private int size;

    public FloatHashBag() {
        this.items = new FloatIntHashMap();
    }

    public FloatHashBag(int size) {
        this.items = new FloatIntHashMap(size);
    }

    public FloatHashBag(FloatIterable iterable) {
        this();
        this.addAll(iterable);
    }

    public FloatHashBag(float ... elements) {
        this();
        this.addAll(elements);
    }

    public FloatHashBag(FloatHashBag bag) {
        this.items = new FloatIntHashMap(bag.sizeDistinct());
        bag.forEachWithOccurrences(new FloatIntProcedure(){

            public void value(float item, int occurrences) {
                FloatHashBag.this.addOccurrences(item, occurrences);
            }
        });
    }

    public static FloatHashBag newBag(int size) {
        return new FloatHashBag(size);
    }

    public static FloatHashBag newBagWith(float ... source) {
        FloatHashBag result = new FloatHashBag();
        result.addAll(source);
        return result;
    }

    public static FloatHashBag newBag(FloatIterable source) {
        if (source instanceof FloatHashBag) {
            return new FloatHashBag((FloatHashBag)source);
        }
        return new FloatHashBag(source);
    }

    public static FloatHashBag newBag(FloatBag source) {
        final FloatHashBag result = new FloatHashBag();
        source.forEachWithOccurrences(new FloatIntProcedure(){

            public void value(float each, int occurrences) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.items.notEmpty();
    }

    public int size() {
        return this.size;
    }

    public int sizeDistinct() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
        this.size = 0;
    }

    public FloatHashBag with(float element) {
        this.add(element);
        return this;
    }

    public FloatHashBag with(float element1, float element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public FloatHashBag with(float element1, float element2, float element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public FloatHashBag withAll(FloatIterable iterable) {
        this.addAll(iterable);
        return this;
    }

    public FloatHashBag without(float element) {
        this.remove(element);
        return this;
    }

    public FloatHashBag withoutAll(FloatIterable iterable) {
        this.removeAll(iterable);
        return this;
    }

    public boolean contains(float value) {
        return this.items.containsKey(value);
    }

    public int occurrencesOf(float item) {
        return this.items.get(item);
    }

    public void forEachWithOccurrences(FloatIntProcedure procedure) {
        this.items.forEachKeyValue(procedure);
    }

    public boolean add(float item) {
        this.items.updateValue(item, 0, IntToIntFunctions.increment());
        ++this.size;
        return true;
    }

    public boolean remove(float item) {
        int newValue = this.items.updateValue(item, 0, IntToIntFunctions.decrement());
        if (newValue <= 0) {
            this.items.removeKey(item);
            if (newValue == 0) {
                --this.size;
            }
            return newValue == 0;
        }
        --this.size;
        return true;
    }

    public boolean addAll(float ... source) {
        if (source.length == 0) {
            return false;
        }
        for (float each : source) {
            this.add(each);
        }
        return true;
    }

    public boolean addAll(FloatIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        if (source instanceof FloatBag) {
            FloatBag otherBag = (FloatBag)source;
            otherBag.forEachWithOccurrences(new FloatIntProcedure(){

                public void value(float each, int occurrences) {
                    FloatHashBag.this.addOccurrences(each, occurrences);
                }
            });
        } else {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                float each = iterator.next();
                this.add(each);
            }
        }
        return true;
    }

    public boolean removeAll(float ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (float each : source) {
            int occurrences = this.items.removeKeyIfAbsent(each, 0);
            this.size -= occurrences;
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(FloatIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof FloatBag) {
            FloatBag otherBag = (FloatBag)source;
            otherBag.forEachWithOccurrences(new FloatIntProcedure(){

                public void value(float each, int occurrences) {
                    int oldOccurrences = FloatHashBag.this.items.removeKeyIfAbsent(each, 0);
                    FloatHashBag.this.size -= oldOccurrences;
                }
            });
        } else {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                float each = iterator.next();
                int occurrences = this.items.removeKeyIfAbsent(each, 0);
                this.size -= occurrences;
            }
        }
        return this.size() != oldSize;
    }

    public boolean retainAll(FloatIterable source) {
        int oldSize = this.size();
        Object sourceSet = source instanceof FloatSet ? (FloatSet)source : source.toSet();
        FloatHashBag retained = this.select(new FloatPredicate((FloatSet)sourceSet){
            final /* synthetic */ FloatSet val$sourceSet;
            {
                this.val$sourceSet = floatSet;
            }

            public boolean accept(float key) {
                return this.val$sourceSet.contains(key);
            }
        });
        if (retained.size() != oldSize) {
            this.items = retained.items;
            this.size = retained.size;
            return true;
        }
        return false;
    }

    public boolean retainAll(float ... source) {
        return this.retainAll(FloatHashSet.newSetWith(source));
    }

    public void addOccurrences(float item, final int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            this.items.updateValue(item, 0, new IntToIntFunction(){

                public int valueOf(int intParameter) {
                    return intParameter + occurrences;
                }
            });
            this.size += occurrences;
        }
    }

    public boolean removeOccurrences(float item, final int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot remove a negative number of occurrences");
        }
        if (occurrences == 0) {
            return false;
        }
        int newValue = this.items.updateValue(item, 0, new IntToIntFunction(){

            public int valueOf(int intParameter) {
                return intParameter - occurrences;
            }
        });
        if (newValue <= 0) {
            this.size -= occurrences - newValue;
            this.items.removeKey(item);
            return newValue + occurrences != 0;
        }
        this.size -= occurrences;
        return true;
    }

    public void forEach(final FloatProcedure procedure) {
        this.items.forEachKeyValue(new FloatIntProcedure(){

            public void value(float key, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    procedure.value(key);
                }
            }
        });
    }

    public FloatHashBag select(final FloatPredicate predicate) {
        final FloatHashBag result = new FloatHashBag();
        this.forEachWithOccurrences(new FloatIntProcedure(){

            public void value(float each, int occurrences) {
                if (predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    public FloatHashBag reject(final FloatPredicate predicate) {
        final FloatHashBag result = new FloatHashBag();
        this.forEachWithOccurrences(new FloatIntProcedure(){

            public void value(float each, int occurrences) {
                if (!predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        MutableFloatIterator it = this.floatIterator();
        while (it.hasNext()) {
            result = function.valueOf(result, it.next());
        }
        return result;
    }

    public boolean equals(Object otherBag) {
        if (otherBag == this) {
            return true;
        }
        if (!(otherBag instanceof FloatBag)) {
            return false;
        }
        final FloatBag bag = (FloatBag)otherBag;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        return this.items.keysView().allSatisfy(new FloatPredicate(){

            public boolean accept(float key) {
                return FloatHashBag.this.occurrencesOf(key) == bag.occurrencesOf(key);
            }
        });
    }

    public int hashCode() {
        final Counter result = new Counter();
        this.forEachWithOccurrences(new FloatIntProcedure(){

            public void value(float eachItem, int occurrences) {
                result.add(Float.floatToIntBits(eachItem) ^ occurrences);
            }
        });
        return result.getCount();
    }

    public void appendString(final Appendable appendable, String start, final String separator, String end) {
        final boolean[] firstItem = new boolean[]{true};
        try {
            appendable.append(start);
            this.items.forEachKeyValue(new FloatIntProcedure(){

                public void value(float each, int occurrences) {
                    try {
                        for (int i = 0; i < occurrences; ++i) {
                            if (!firstItem[0]) {
                                appendable.append(separator);
                            }
                            appendable.append(String.valueOf(each));
                            firstItem[0] = false;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int count(final FloatPredicate predicate) {
        final Counter result = new Counter();
        this.forEachWithOccurrences(new FloatIntProcedure(){

            public void value(float each, int occurrences) {
                if (predicate.accept(each)) {
                    result.add(occurrences);
                }
            }
        });
        return result.getCount();
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.items.keysView().anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.items.keysView().allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.items.keysView().noneSatisfy(predicate);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.items.keysView().detectIfNone(predicate, ifNone);
    }

    public <V> MutableBag<V> collect(final FloatToObjectFunction<? extends V> function) {
        final HashBag result = HashBag.newBag(this.items.size());
        this.forEachWithOccurrences(new FloatIntProcedure(){

            public void value(float each, int occurrences) {
                result.addOccurrences(function.valueOf(each), occurrences);
            }
        });
        return result;
    }

    public float max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().max();
    }

    public float min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().min();
    }

    public double sum() {
        final double[] result = new double[]{0.0};
        this.forEachWithOccurrences(new FloatIntProcedure(){

            public void value(float each, int occurrences) {
                result[0] = result[0] + (double)each * (double)occurrences;
            }
        });
        return result[0];
    }

    public float[] toArray() {
        final float[] array = new float[this.size()];
        final int[] index = new int[]{0};
        this.forEachWithOccurrences(new FloatIntProcedure(){

            public void value(float each, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    array[index[0]] = each;
                    index[0] = index[0] + 1;
                }
            }
        });
        return array;
    }

    public MutableFloatBag asUnmodifiable() {
        return new UnmodifiableFloatBag(this);
    }

    public MutableFloatBag asSynchronized() {
        return new SynchronizedFloatBag(this);
    }

    public ImmutableFloatBag toImmutable() {
        return FloatBags.immutable.withAll((FloatIterable)this);
    }

    public MutableFloatIterator floatIterator() {
        return new InternalIterator();
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.items.size());
        try {
            this.items.forEachKeyValue(new FloatIntProcedure(){

                public void value(float each, int occurrences) {
                    try {
                        out.writeFloat(each);
                        out.writeInt(occurrences);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        this.items = new FloatIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.addOccurrences(in.readFloat(), in.readInt());
        }
    }

    private class InternalIterator
    implements MutableFloatIterator {
        private final MutableFloatIterator floatIterator;
        private float currentItem;
        private int occurrences;
        private boolean canRemove;

        private InternalIterator() {
            this.floatIterator = FloatHashBag.this.items.keySet().floatIterator();
        }

        public boolean hasNext() {
            return this.occurrences > 0 || this.floatIterator.hasNext();
        }

        public float next() {
            if (this.occurrences == 0) {
                this.currentItem = this.floatIterator.next();
                this.occurrences = FloatHashBag.this.occurrencesOf(this.currentItem);
            }
            --this.occurrences;
            this.canRemove = true;
            return this.currentItem;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            this.floatIterator.remove();
            this.canRemove = false;
        }
    }
}

