/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntIntProcedure;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.ImmutableIntList;
import com.gs.collections.api.list.primitive.IntList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedIntCollection;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseIntIterable;
import com.gs.collections.impl.list.mutable.primitive.UnmodifiableIntList;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedIntList
extends AbstractSynchronizedIntCollection
implements MutableIntList {
    private static final long serialVersionUID = 1L;

    SynchronizedIntList(MutableIntList list) {
        super((MutableIntCollection)list);
    }

    SynchronizedIntList(MutableIntList list, Object newLock) {
        super((MutableIntCollection)list, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableIntList getMutableIntList() {
        return (MutableIntList)this.getIntCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFirst() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLast() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(int value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().indexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(int value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().lastIndexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAtIndex(int index, int element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntList().addAtIndex(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAllAtIndex(int index, int ... source) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().addAllAtIndex(index, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAllAtIndex(int index, IntIterable source) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().addAllAtIndex(index, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeAtIndex(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().removeAtIndex(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set(int index, int element) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedIntList with(int element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntList().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedIntList without(int element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntList().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedIntList withAll(IntIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntList().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedIntList withoutAll(IntIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntList().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntList select(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntList reject(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableList<V> collect(IntToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntList sortThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntList().sortThis();
        }
        return this;
    }

    public long dotProduct(IntList list) {
        return this.getMutableIntList().dotProduct(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherList) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().equals(otherList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyIntIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyIntIterableAdapter((IntIterable)this);
        }
    }

    public MutableIntList asUnmodifiable() {
        return new UnmodifiableIntList(this);
    }

    public MutableIntList asSynchronized() {
        return this;
    }

    public ImmutableIntList toImmutable() {
        int size = this.size();
        if (size == 0) {
            return IntLists.immutable.with();
        }
        if (size == 1) {
            return IntLists.immutable.with(this.getFirst());
        }
        return IntLists.immutable.with(this.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntList reverseThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntList().reverseThis();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntList toReversed() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().toReversed();
        }
    }

    public LazyIntIterable asReversed() {
        return ReverseIntIterable.adapt((IntList)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithIndex(IntIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableIntList().forEachWithIndex(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableIntList().injectIntoWithIndex(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntList distinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableIntList().distinct();
        }
    }

    public MutableIntList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}

