/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ByteToShortFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.ByteShortPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.iterator.MutableByteIterator;
import com.gs.collections.api.iterator.MutableShortIterator;
import com.gs.collections.api.map.primitive.ByteShortMap;
import com.gs.collections.api.map.primitive.ImmutableByteShortMap;
import com.gs.collections.api.map.primitive.MutableByteShortMap;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.api.tuple.primitive.ByteShortPair;
import com.gs.collections.impl.factory.primitive.ByteShortMaps;
import com.gs.collections.impl.iterator.UnmodifiableByteIterator;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyByteIterable;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableByteKeySet;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableShortValuesMap;
import com.gs.collections.impl.map.mutable.primitive.ImmutableByteMapKeySet;
import com.gs.collections.impl.map.mutable.primitive.MutableByteKeysMap;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedByteShortMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableByteShortMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteShortHashMap
extends AbstractMutableShortValuesMap
implements MutableByteShortMap,
Externalizable,
MutableByteKeysMap {
    private static final short EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_KEY = 0;
    private static final byte REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 1;
    private static final int INITIAL_LINEAR_PROBE = 32;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private byte[] keys;
    private short[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableShortValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public ByteShortHashMap() {
        this.allocateTable(16);
    }

    public ByteShortHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public ByteShortHashMap(ByteShortMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static ByteShortHashMap newWithKeysValues(byte key1, short value1) {
        return new ByteShortHashMap(1).withKeyValue(key1, value1);
    }

    public static ByteShortHashMap newWithKeysValues(byte key1, short value1, byte key2, short value2) {
        return new ByteShortHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ByteShortHashMap newWithKeysValues(byte key1, short value1, byte key2, short value2, byte key3, short value3) {
        return new ByteShortHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ByteShortHashMap newWithKeysValues(byte key1, short value1, byte key2, short value2, byte key3, short value3, byte key4, short value4) {
        return new ByteShortHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableShortValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected short getEmptyValue() {
        return 0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected short getValueAtIndex(int index) {
        return this.values[index];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteShortMap)) {
            return false;
        }
        ByteShortMap other = (ByteShortMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((byte)0) || other.containsKey((byte)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((byte)0) || this.sentinelValues.zeroValue != other.getOrThrow((byte)0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((byte)1) || this.sentinelValues.oneValue != other.getOrThrow((byte)1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte key = this.keys[i];
            if (!ByteShortHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteShortHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte key = this.keys[i];
            if (!ByteShortHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectShortToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteShortHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, (byte)0);
        Arrays.fill(this.values, (short)0);
    }

    public void put(byte key, short value) {
        if (ByteShortHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (ByteShortHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        byte keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(short value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(short value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(ByteShortMap map) {
        map.forEachKeyValue(new ByteShortProcedure(){

            public void value(byte key, short value) {
                ByteShortHashMap.this.put(key, value);
            }
        });
    }

    @Override
    public void removeKey(byte key) {
        if (ByteShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (ByteShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(byte key) {
        this.removeKey(key);
    }

    public short removeKeyIfAbsent(byte key, short value) {
        if (ByteShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            short oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (ByteShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            short oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            short oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public short getIfAbsentPut(byte key, short value) {
        if (ByteShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getIfAbsentPut(byte key, ShortFunction0 function) {
        if (ByteShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> short getIfAbsentPutWith(byte key, ShortFunction<? super P> function, P parameter) {
        if (ByteShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.shortValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.shortValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.shortValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getIfAbsentPutWithKey(byte key, ByteToShortFunction function) {
        if (ByteShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short addToValue(byte key, short toBeAdded) {
        if (ByteShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (short)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (short)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = (short)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(byte key, short value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1;
        this.values[index] = 0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
        if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
            this.rehash();
        }
    }

    private void copyKeys() {
        byte[] copy = new byte[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    public short updateValue(byte key, short initialValueIfAbsent, ShortToShortFunction function) {
        if (ByteShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        short value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public ByteShortHashMap withKeyValue(byte key1, short value1) {
        this.put(key1, value1);
        return this;
    }

    public ByteShortHashMap withKeysValues(byte key1, short value1, byte key2, short value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ByteShortHashMap withKeysValues(byte key1, short value1, byte key2, short value2, byte key3, short value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ByteShortHashMap withKeysValues(byte key1, short value1, byte key2, short value2, byte key3, short value3, byte key4, short value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ByteShortHashMap withoutKey(byte key) {
        this.removeKey(key);
        return this;
    }

    public ByteShortHashMap withoutAllKeys(ByteIterable keys) {
        keys.forEach(new ByteProcedure(){

            public void value(byte key) {
                ByteShortHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableByteShortMap asUnmodifiable() {
        return new UnmodifiableByteShortMap(this);
    }

    public MutableByteShortMap asSynchronized() {
        return new SynchronizedByteShortMap(this);
    }

    public ImmutableByteShortMap toImmutable() {
        return ByteShortMaps.immutable.ofAll((ByteShortMap)this);
    }

    public short get(byte key) {
        return this.getIfAbsent(key, (short)0);
    }

    public short getIfAbsent(byte key, short ifAbsent) {
        if (ByteShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public short getOrThrow(byte key) {
        if (ByteShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ByteShortHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(byte key) {
        if (ByteShortHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ByteShortHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((byte)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((byte)1);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(ByteShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyByteIterable keysView() {
        return new KeysView();
    }

    public RichIterable<ByteShortPair> keyValuesView() {
        return new KeyValuesView();
    }

    public ByteShortHashMap select(ByteShortPredicate predicate) {
        ByteShortHashMap result = new ByteShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((byte)0, this.sentinelValues.zeroValue)) {
                result.put((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((byte)1, this.sentinelValues.oneValue)) {
                result.put((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public ByteShortHashMap reject(ByteShortPredicate predicate) {
        ByteShortHashMap result = new ByteShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((byte)0, this.sentinelValues.zeroValue)) {
                result.put((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((byte)1, this.sentinelValues.oneValue)) {
                result.put((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeByte(0);
                out.writeShort(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeByte(1);
                out.writeShort(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteShortHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeByte(this.keys[i]);
            out.writeShort(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readByte(), in.readShort());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        byte[] old = this.keys;
        short[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ByteShortHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(byte element) {
        int index = this.spreadAndMask(element);
        byte keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spreadAndMask(byte element) {
        return this.mask(element);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new byte[sizeToAllocate];
        this.values = new short[sizeToAllocate];
    }

    private static boolean isEmptyKey(byte key) {
        return key == 0;
    }

    private static boolean isRemovedKey(byte key) {
        return key == 1;
    }

    private static boolean isNonSentinel(byte key) {
        return !ByteShortHashMap.isEmptyKey(key) && !ByteShortHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !ByteShortHashMap.isEmptyKey(this.keys[index]) && !ByteShortHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length >> 2;
    }

    public MutableByteSet keySet() {
        return new KeySet();
    }

    public MutableShortCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ byte[] access$302(ByteShortHashMap x0, byte[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ short[] access$502(ByteShortHashMap x0, short[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<ByteShortPair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super ByteShortPair> procedure) {
            if (ByteShortHashMap.this.sentinelValues != null) {
                if (((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)0, ((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.zeroValue));
                }
                if (((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)1, ((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < ByteShortHashMap.this.keys.length; ++i) {
                if (!ByteShortHashMap.isNonSentinel(ByteShortHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ByteShortHashMap.this.keys[i], ByteShortHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ByteShortPair> objectIntProcedure) {
            int index = 0;
            if (ByteShortHashMap.this.sentinelValues != null) {
                if (((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((byte)0, ((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((byte)1, ((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < ByteShortHashMap.this.keys.length; ++i) {
                if (!ByteShortHashMap.isNonSentinel(ByteShortHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(ByteShortHashMap.this.keys[i], ByteShortHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ByteShortPair, ? super P> procedure, P parameter) {
            if (ByteShortHashMap.this.sentinelValues != null) {
                if (((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)0, ((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)1, ((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < ByteShortHashMap.this.keys.length; ++i) {
                if (!ByteShortHashMap.isNonSentinel(ByteShortHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ByteShortHashMap.this.keys[i], ByteShortHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<ByteShortPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<ByteShortPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public ByteShortPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (ByteShortHashMap.this.containsKey((byte)0)) {
                        return PrimitiveTuples.pair((byte)0, ((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (ByteShortHashMap.this.containsKey((byte)1)) {
                        return PrimitiveTuples.pair((byte)1, ((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.oneValue);
                    }
                }
                byte[] keys = ByteShortHashMap.this.keys;
                while (!ByteShortHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ByteShortPair result = PrimitiveTuples.pair(keys[this.position], ByteShortHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ByteShortHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableShortValuesMap.AbstractShortValuesCollection {
        private ValuesCollection() {
        }

        public MutableShortIterator shortIterator() {
            return ByteShortHashMap.this.shortIterator();
        }

        public boolean remove(short item) {
            int oldSize = ByteShortHashMap.this.size();
            if (ByteShortHashMap.this.sentinelValues != null) {
                if (((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.containsZeroKey && item == ((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.zeroValue) {
                    ByteShortHashMap.this.removeKey((byte)0);
                }
                if (((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.containsOneKey && item == ((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.oneValue) {
                    ByteShortHashMap.this.removeKey((byte)1);
                }
            }
            for (int i = 0; i < ByteShortHashMap.this.keys.length; ++i) {
                if (!ByteShortHashMap.isNonSentinel(ByteShortHashMap.this.keys[i]) || item != ByteShortHashMap.this.values[i]) continue;
                ByteShortHashMap.this.removeKey(ByteShortHashMap.this.keys[i]);
            }
            return oldSize != ByteShortHashMap.this.size();
        }

        public boolean retainAll(ShortIterable source) {
            int oldSize = ByteShortHashMap.this.size();
            Object sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            ByteShortHashMap retained = ByteShortHashMap.this.select(new ByteShortPredicate((ShortSet)sourceSet){
                final /* synthetic */ ShortSet val$sourceSet;
                {
                    this.val$sourceSet = shortSet;
                }

                public boolean accept(byte key, short value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                ByteShortHashMap.access$302(ByteShortHashMap.this, retained.keys);
                ByteShortHashMap.access$502(ByteShortHashMap.this, retained.values);
                ByteShortHashMap.this.sentinelValues = retained.sentinelValues;
                ByteShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                ByteShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }
    }

    private class KeySet
    extends AbstractMutableByteKeySet {
        private KeySet() {
        }

        protected MutableByteKeysMap getOuter() {
            return ByteShortHashMap.this;
        }

        protected AbstractMutableShortValuesMap.SentinelValues getSentinelValues() {
            return ByteShortHashMap.this.sentinelValues;
        }

        protected byte getKeyAtIndex(int index) {
            return ByteShortHashMap.this.keys[index];
        }

        protected int getTableSize() {
            return ByteShortHashMap.this.keys.length;
        }

        public MutableByteIterator byteIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(ByteIterable source) {
            int oldSize = ByteShortHashMap.this.size();
            Object sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            ByteShortHashMap retained = ByteShortHashMap.this.select(new ByteShortPredicate((ByteSet)sourceSet){
                final /* synthetic */ ByteSet val$sourceSet;
                {
                    this.val$sourceSet = byteSet;
                }

                public boolean accept(byte key, short value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                ByteShortHashMap.access$302(ByteShortHashMap.this, retained.keys);
                ByteShortHashMap.access$502(ByteShortHashMap.this, retained.values);
                ByteShortHashMap.this.sentinelValues = retained.sentinelValues;
                ByteShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                ByteShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(byte ... source) {
            return this.retainAll((ByteIterable)ByteHashSet.newSetWith(source));
        }

        public ByteSet freeze() {
            ByteShortHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (ByteShortHashMap.this.sentinelValues != null) {
                containsZeroKey = ((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((ByteShortHashMap)ByteShortHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableByteMapKeySet(ByteShortHashMap.this.keys, ByteShortHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }
    }

    private class KeySetIterator
    implements MutableByteIterator {
        private int count;
        private int position;
        private byte lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteShortHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteShortHashMap.this.containsKey((byte)0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteShortHashMap.this.containsKey((byte)1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            byte[] keys = ByteShortHashMap.this.keys;
            while (!ByteShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ByteShortHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyByteIterable {
        private KeysView() {
        }

        public ByteIterator byteIterator() {
            return new UnmodifiableByteIterator((ByteIterator)new KeySetIterator());
        }

        public void forEach(ByteProcedure procedure) {
            ByteShortHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalShortIterator
    implements MutableShortIterator {
        private int count;
        private int position;
        private byte lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalShortIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteShortHashMap.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteShortHashMap.this.containsKey((byte)0)) {
                    this.lastKey = 0;
                    return ByteShortHashMap.this.get((byte)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteShortHashMap.this.containsKey((byte)1)) {
                    this.lastKey = 1;
                    return ByteShortHashMap.this.get((byte)1);
                }
            }
            byte[] keys = ByteShortHashMap.this.keys;
            while (!ByteShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            short result = ByteShortHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ByteShortHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

