/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;

public abstract class AbstractBooleanIterable
implements BooleanIterable {
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newList(this);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet(this);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag(this);
    }

    public boolean containsAll(boolean ... source) {
        for (boolean item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        return source.allSatisfy(new BooleanPredicate(){

            public boolean accept(boolean each) {
                return AbstractBooleanIterable.this.contains(each);
            }
        });
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }
}

