/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.strategy.immutable;

import com.gs.collections.api.block.HashingStrategy;
import com.gs.collections.api.factory.set.strategy.ImmutableHashingStrategySetFactory;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.impl.set.strategy.immutable.ImmutableEmptySetWithHashingStrategy;
import com.gs.collections.impl.set.strategy.immutable.ImmutableUnifiedSetWithHashingStrategy;
import com.gs.collections.impl.utility.Iterate;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class ImmutableHashingStrategySetFactoryImpl
implements ImmutableHashingStrategySetFactory {
    public <T> ImmutableSet<T> of(HashingStrategy<? super T> hashingStrategy) {
        return this.with(hashingStrategy);
    }

    public <T> ImmutableSet<T> with(HashingStrategy<? super T> hashingStrategy) {
        return new ImmutableEmptySetWithHashingStrategy<T>(hashingStrategy);
    }

    public <T> ImmutableSet<T> of(HashingStrategy<? super T> hashingStrategy, T ... items) {
        return this.with(hashingStrategy, items);
    }

    public <T> ImmutableSet<T> with(HashingStrategy<? super T> hashingStrategy, T ... items) {
        if (items == null || items.length == 0) {
            return this.of(hashingStrategy);
        }
        return ImmutableUnifiedSetWithHashingStrategy.newSetWith(hashingStrategy, items);
    }

    public <T> ImmutableSet<T> ofAll(HashingStrategy<? super T> hashingStrategy, Iterable<? extends T> items) {
        return this.withAll(hashingStrategy, items);
    }

    public <T> ImmutableSet<T> withAll(HashingStrategy<? super T> hashingStrategy, Iterable<? extends T> items) {
        return this.with(hashingStrategy, Iterate.toArray(items));
    }
}

