/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.factory.stack.primitive.MutableDoubleStackFactory;
import com.gs.collections.api.stack.primitive.MutableDoubleStack;
import com.gs.collections.impl.stack.mutable.primitive.DoubleArrayStack;

public class MutableDoubleStackFactoryImpl
implements MutableDoubleStackFactory {
    public MutableDoubleStack empty() {
        return new DoubleArrayStack();
    }

    public MutableDoubleStack of() {
        return this.empty();
    }

    public MutableDoubleStack with() {
        return this.empty();
    }

    public MutableDoubleStack of(double ... items) {
        return this.with(items);
    }

    public MutableDoubleStack with(double ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return DoubleArrayStack.newStackWith(items);
    }

    public MutableDoubleStack ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    public MutableDoubleStack withAll(DoubleIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return DoubleArrayStack.newStack(items);
    }

    public MutableDoubleStack ofAllReversed(DoubleIterable items) {
        return this.withAllReversed(items);
    }

    public MutableDoubleStack withAllReversed(DoubleIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return DoubleArrayStack.newStackFromTopToBottom(items);
    }
}

