/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.message.DbException;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueNull;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class DateTimeUtils {
    public static final long MILLIS_PER_DAY = 86400000L;
    private static final long NANOS_PER_DAY = 86400000000000L;
    private static final int SHIFT_YEAR = 9;
    private static final int SHIFT_MONTH = 5;
    private static final int[] NORMAL_DAYS_PER_MONTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] DAYS_OFFSET = new int[]{0, 31, 61, 92, 122, 153, 184, 214, 245, 275, 306, 337, 366};
    private static final ThreadLocal<Calendar> CACHED_CALENDAR = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };

    private DateTimeUtils() {
    }

    public static void resetCalendar() {
        CACHED_CALENDAR.remove();
    }

    public static java.sql.Date convertDate(Value value, Calendar calendar) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        ValueDate valueDate = (ValueDate)value.convertTo(10);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear();
        calendar2.setLenient(true);
        long l = valueDate.getDateValue();
        DateTimeUtils.setCalendarFields(calendar2, DateTimeUtils.yearFromDateValue(l), DateTimeUtils.monthFromDateValue(l), DateTimeUtils.dayFromDateValue(l), 0, 0, 0, 0);
        long l2 = calendar2.getTimeInMillis();
        return new java.sql.Date(l2);
    }

    public static Time convertTime(Value value, Calendar calendar) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        ValueTime valueTime = (ValueTime)value.convertTo(9);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear();
        calendar2.setLenient(true);
        long l = valueTime.getNanos();
        long l2 = l / 1000000L;
        l -= l2 * 1000000L;
        long l3 = l2 / 1000L;
        l2 -= l3 * 1000L;
        long l4 = l3 / 60L;
        l3 -= l4 * 60L;
        long l5 = l4 / 60L;
        DateTimeUtils.setCalendarFields(calendar2, 1970, 1, 1, (int)l5, (int)(l4 -= l5 * 60L), (int)l3, (int)l2);
        long l6 = calendar2.getTimeInMillis();
        return new Time(l6);
    }

    public static Timestamp convertTimestamp(Value value, Calendar calendar) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear();
        calendar2.setLenient(true);
        long l = valueTimestamp.getDateValue();
        long l2 = valueTimestamp.getTimeNanos();
        long l3 = l2 / 1000000L;
        l2 -= l3 * 1000000L;
        long l4 = l3 / 1000L;
        l3 -= l4 * 1000L;
        long l5 = l4 / 60L;
        l4 -= l5 * 60L;
        long l6 = l5 / 60L;
        DateTimeUtils.setCalendarFields(calendar2, DateTimeUtils.yearFromDateValue(l), DateTimeUtils.monthFromDateValue(l), DateTimeUtils.dayFromDateValue(l), (int)l6, (int)(l5 -= l6 * 60L), (int)l4, (int)l3);
        long l7 = calendar2.getTimeInMillis();
        Timestamp timestamp = new Timestamp(l7);
        timestamp.setNanos((int)(l2 + l3 * 1000000L));
        return timestamp;
    }

    public static ValueDate convertDate(java.sql.Date date, Calendar calendar) {
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeInMillis(date.getTime());
        long l = DateTimeUtils.dateValueFromCalendar(calendar2);
        return ValueDate.fromDateValue(l);
    }

    public static ValueTime convertTime(Time time, Calendar calendar) {
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeInMillis(time.getTime());
        long l = DateTimeUtils.nanosFromCalendar(calendar2);
        return ValueTime.fromNanos(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToLocal(Date date, Calendar calendar) {
        Calendar calendar2;
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        calendar = (Calendar)calendar.clone();
        Calendar calendar3 = calendar2 = Calendar.getInstance();
        synchronized (calendar3) {
            calendar2.setTime(date);
            DateTimeUtils.convertTime(calendar2, calendar);
        }
        return calendar.getTime().getTime();
    }

    private static void convertTime(Calendar calendar, Calendar calendar2) {
        calendar2.set(0, calendar.get(0));
        calendar2.set(1, calendar.get(1));
        calendar2.set(2, calendar.get(2));
        calendar2.set(5, calendar.get(5));
        calendar2.set(11, calendar.get(11));
        calendar2.set(12, calendar.get(12));
        calendar2.set(13, calendar.get(13));
        calendar2.set(14, calendar.get(14));
    }

    public static ValueTimestamp convertTimestamp(Timestamp timestamp, Calendar calendar) {
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeInMillis(timestamp.getTime());
        long l = DateTimeUtils.dateValueFromCalendar(calendar2);
        long l2 = DateTimeUtils.nanosFromCalendar(calendar2);
        return ValueTimestamp.fromDateValueAndNanos(l, l2 += (long)(timestamp.getNanos() % 1000000));
    }

    public static long parseDateValue(String string, int n, int n2) {
        int n3;
        int n4;
        if (string.charAt(n) == '+') {
            ++n;
        }
        int n5 = string.indexOf(45, n + 1);
        int n6 = string.indexOf(45, n5 + 1);
        if (n5 <= 0 || n6 <= n5) {
            throw new IllegalArgumentException(string);
        }
        int n7 = Integer.parseInt(string.substring(n, n5));
        if (!DateTimeUtils.isValidDate(n7, n4 = Integer.parseInt(string.substring(n5 + 1, n6)), n3 = Integer.parseInt(string.substring(n6 + 1, n2)))) {
            throw new IllegalArgumentException(n7 + "-" + n4 + "-" + n3);
        }
        return DateTimeUtils.dateValue(n7, n4, n3);
    }

    public static long parseTimeNanos(String string, int n, int n2, boolean bl) {
        boolean bl2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        long l = 0L;
        int n6 = string.indexOf(58, n);
        int n7 = string.indexOf(58, n6 + 1);
        int n8 = string.indexOf(46, n7 + 1);
        if (n6 <= 0 || n7 <= n6) {
            throw new IllegalArgumentException(string);
        }
        n3 = Integer.parseInt(string.substring(n, n6));
        if (n3 < 0) {
            if (bl) {
                throw new IllegalArgumentException(string);
            }
            bl2 = true;
            n3 = -n3;
        } else {
            bl2 = false;
        }
        n4 = Integer.parseInt(string.substring(n6 + 1, n7));
        if (n8 < 0) {
            n5 = Integer.parseInt(string.substring(n7 + 1, n2));
        } else {
            n5 = Integer.parseInt(string.substring(n7 + 1, n8));
            String string2 = (string.substring(n8 + 1, n2) + "000000000").substring(0, 9);
            l = Integer.parseInt(string2);
        }
        if (n3 >= 2000000 || n4 < 0 || n4 >= 60 || n5 < 0 || n5 >= 60) {
            throw new IllegalArgumentException(string);
        }
        if (bl && n3 >= 24) {
            throw new IllegalArgumentException(string);
        }
        return bl2 ? -l : (l += (((long)n3 * 60L + (long)n4) * 60L + (long)n5) * 1000000000L);
    }

    public static long getMillis(TimeZone timeZone, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        try {
            return DateTimeUtils.getTimeTry(false, timeZone, n, n2, n3, n4, n5, n6, n7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = illegalArgumentException.toString();
            if (string.indexOf("HOUR_OF_DAY") > 0) {
                if (n4 < 0 || n4 > 23) {
                    throw illegalArgumentException;
                }
                return DateTimeUtils.getTimeTry(true, timeZone, n, n2, n3, n4, n5, n6, n7);
            }
            if (string.indexOf("DAY_OF_MONTH") > 0) {
                int n8 = n2 == 2 ? (new GregorianCalendar().isLeapYear(n) ? 29 : 28) : 30 + (n2 + (n2 > 7 ? 1 : 0) & 1);
                if (n3 < 1 || n3 > n8) {
                    throw illegalArgumentException;
                }
                return DateTimeUtils.getTimeTry(true, timeZone, n, n2, n3, n4 += 6, n5, n6, n7);
            }
            return DateTimeUtils.getTimeTry(true, timeZone, n, n2, n3, n4, n5, n6, n7);
        }
    }

    private static long getTimeTry(boolean bl, TimeZone timeZone, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Calendar calendar = timeZone == null ? CACHED_CALENDAR.get() : Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.setLenient(bl);
        DateTimeUtils.setCalendarFields(calendar, n, n2, n3, n4, n5, n6, n7);
        return calendar.getTime().getTime();
    }

    private static void setCalendarFields(Calendar calendar, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n <= 0) {
            calendar.set(0, 0);
            calendar.set(1, 1 - n);
        } else {
            calendar.set(0, 1);
            calendar.set(1, n);
        }
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, n7);
    }

    public static int getDatePart(Date date, int n) {
        Calendar calendar = CACHED_CALENDAR.get();
        calendar.setTime(date);
        if (n == 1) {
            return DateTimeUtils.getYear(calendar);
        }
        int n2 = calendar.get(n);
        if (n == 2) {
            return n2 + 1;
        }
        return n2;
    }

    private static int getYear(Calendar calendar) {
        int n = calendar.get(1);
        if (calendar.get(0) == 0) {
            n = 1 - n;
        }
        return n;
    }

    public static long getTimeLocalWithoutDst(Date date) {
        return date.getTime() + (long)CACHED_CALENDAR.get().get(15);
    }

    public static long getTimeUTCWithoutDst(long l) {
        return l - (long)CACHED_CALENDAR.get().get(15);
    }

    public static int getIsoDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        int n = calendar.get(7) - 1;
        return n == 0 ? 7 : n;
    }

    public static int getIsoWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        return calendar.get(3);
    }

    public static int getIsoYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        int n = DateTimeUtils.getYear(calendar);
        int n2 = calendar.get(2);
        int n3 = calendar.get(3);
        if (n2 == 0 && n3 > 51) {
            --n;
        } else if (n2 == 11 && n3 == 1) {
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Date date, String string, String string2, String string3) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = DateTimeUtils.getDateFormat(string, string2, string3);
        synchronized (simpleDateFormat2) {
            return simpleDateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String string, String string2, String string3, String string4) {
        SimpleDateFormat simpleDateFormat = DateTimeUtils.getDateFormat(string2, string3, string4);
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(string);
            }
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string);
        }
    }

    private static SimpleDateFormat getDateFormat(String string, String string2, String string3) {
        try {
            SimpleDateFormat simpleDateFormat;
            if (string2 == null) {
                simpleDateFormat = new SimpleDateFormat(string);
            } else {
                Locale locale = new Locale(string2);
                simpleDateFormat = new SimpleDateFormat(string, locale);
            }
            if (string3 != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
            }
            return simpleDateFormat;
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string + "/" + string2 + "/" + string3);
        }
    }

    public static boolean isValidDate(int n, int n2, int n3) {
        if (n2 < 1 || n2 > 12 || n3 < 1) {
            return false;
        }
        if (n > 1582) {
            if (n2 != 2) {
                return n3 <= NORMAL_DAYS_PER_MONTH[n2];
            }
            if ((n & 3) != 0) {
                return n3 <= 28;
            }
            return n3 <= (n % 100 != 0 || n % 400 == 0 ? 29 : 28);
        }
        if (n == 1582 && n2 == 10) {
            return n3 <= 31 && (n3 < 5 || n3 > 14);
        }
        if (n2 != 2 && n3 <= NORMAL_DAYS_PER_MONTH[n2]) {
            return true;
        }
        return n3 <= ((n & 3) != 0 ? 28 : 29);
    }

    public static java.sql.Date convertDateValueToDate(long l) {
        long l2 = DateTimeUtils.getMillis(null, DateTimeUtils.yearFromDateValue(l), DateTimeUtils.monthFromDateValue(l), DateTimeUtils.dayFromDateValue(l), 0, 0, 0, 0);
        return new java.sql.Date(l2);
    }

    public static Timestamp convertDateValueToTimestamp(long l, long l2) {
        long l3 = l2 / 1000000L;
        l2 -= l3 * 1000000L;
        long l4 = l3 / 1000L;
        l3 -= l4 * 1000L;
        long l5 = l4 / 60L;
        l4 -= l5 * 60L;
        long l6 = l5 / 60L;
        long l7 = DateTimeUtils.getMillis(null, DateTimeUtils.yearFromDateValue(l), DateTimeUtils.monthFromDateValue(l), DateTimeUtils.dayFromDateValue(l), (int)l6, (int)(l5 -= l6 * 60L), (int)l4, 0);
        Timestamp timestamp = new Timestamp(l7);
        timestamp.setNanos((int)(l2 + l3 * 1000000L));
        return timestamp;
    }

    public static Time convertNanoToTime(long l) {
        long l2 = l / 1000000L;
        long l3 = l2 / 1000L;
        l2 -= l3 * 1000L;
        long l4 = l3 / 60L;
        l3 -= l4 * 60L;
        long l5 = l4 / 60L;
        long l6 = DateTimeUtils.getMillis(null, 1970, 1, 1, (int)(l5 % 24L), (int)(l4 -= l5 * 60L), (int)l3, (int)l2);
        return new Time(l6);
    }

    public static int yearFromDateValue(long l) {
        return (int)(l >>> 9);
    }

    public static int monthFromDateValue(long l) {
        return (int)(l >>> 5) & 0xF;
    }

    public static int dayFromDateValue(long l) {
        return (int)(l & 0x1FL);
    }

    public static long dateValue(long l, int n, int n2) {
        return l << 9 | (long)(n << 5) | (long)n2;
    }

    public static long dateValueFromDate(long l) {
        Calendar calendar = CACHED_CALENDAR.get();
        calendar.clear();
        calendar.setTimeInMillis(l);
        return DateTimeUtils.dateValueFromCalendar(calendar);
    }

    private static long dateValueFromCalendar(Calendar calendar) {
        int n = DateTimeUtils.getYear(calendar);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        return (long)n << 9 | (long)(n2 << 5) | (long)n3;
    }

    public static long nanosFromDate(long l) {
        Calendar calendar = CACHED_CALENDAR.get();
        calendar.clear();
        calendar.setTimeInMillis(l);
        return DateTimeUtils.nanosFromCalendar(calendar);
    }

    private static long nanosFromCalendar(Calendar calendar) {
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        int n4 = calendar.get(14);
        return ((((long)n * 60L + (long)n2) * 60L + (long)n3) * 1000L + (long)n4) * 1000000L;
    }

    public static ValueTimestamp normalizeTimestamp(long l, long l2) {
        if (l2 > 86400000000000L || l2 < 0L) {
            long l3 = l2 > 86400000000000L ? l2 / 86400000000000L : (l2 - 86400000000000L + 1L) / 86400000000000L;
            l2 -= l3 * 86400000000000L;
            l += l3;
        }
        return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(l), l2);
    }

    public static long absoluteDayFromDateValue(long l) {
        long l2 = DateTimeUtils.yearFromDateValue(l);
        int n = DateTimeUtils.monthFromDateValue(l);
        int n2 = DateTimeUtils.dayFromDateValue(l);
        if (n <= 2) {
            --l2;
            n += 12;
        }
        long l3 = (l2 * 2922L >> 3) + (long)DAYS_OFFSET[n - 3] + (long)n2 - 719484L;
        if (l2 <= 1582L && (l2 < 1582L || n * 100 + n2 < 1005)) {
            l3 += 13L;
        } else if (l2 < 1901L || l2 > 2099L) {
            l3 += l2 / 400L - l2 / 100L + 15L;
        }
        return l3;
    }

    public static long dateValueFromAbsoluteDay(long l) {
        long l2;
        long l3;
        long l4 = l + 719468L;
        long l5 = 0L;
        if (l4 > 578040L) {
            l3 = l4 / 146097L;
            l5 = (l4 -= l3 * 146097L) / 36524L;
            l4 -= l5 * 36524L;
            l2 = l3 * 400L + l5 * 100L;
        } else {
            l4 += 292200000002L;
            l2 = -800000000L;
        }
        l3 = l4 / 1461L;
        long l6 = (l4 -= l3 * 1461L) / 365L;
        if ((l4 -= l6 * 365L) == 0L && (l6 == 4L || l5 == 4L)) {
            --l6;
            l4 += 365L;
        }
        l6 += l2 + l3 * 4L;
        int n = ((int)l4 * 2 + 1) * 5 / 306;
        l4 -= (long)(DAYS_OFFSET[n] - 1);
        if (n >= 10) {
            ++l6;
            n -= 12;
        }
        return DateTimeUtils.dateValue(l6, n + 3, (int)l4);
    }
}

