/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import com.helger.commons.state.ESuccess;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.mojo.javacc.AbstractToolFacade;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

class JJTree
extends AbstractToolFacade {
    private File inputFile;
    private File outputDirectory;
    private String grammarEncoding;
    private String outputEncoding;
    private String jdkVersion;
    private Boolean buildNodeFiles;
    private Boolean multi;
    private Boolean nodeDefaultVoid;
    private String nodeClass;
    private String nodeFactory;
    private String nodePackage;
    private String nodePrefix;
    private Boolean nodeScopeHook;
    private Boolean nodeUsesParser;
    private Boolean trackTokens;
    private Boolean visitor;
    private String visitorDataType;
    private String visitorReturnType;
    private String visitorException;
    private String javaTemplateType;

    JJTree() {
    }

    public void setInputFile(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + file);
        }
        this.inputFile = file;
    }

    public void setOutputDirectory(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + file);
        }
        this.outputDirectory = file;
    }

    public File getOutputFile() {
        File file = null;
        if (this.outputDirectory != null && this.inputFile != null) {
            String string = FileUtils.removeExtension((String)this.inputFile.getName()) + ".jj";
            file = new File(this.outputDirectory, string);
        }
        return file;
    }

    public void setGrammarEncoding(String string) {
        this.grammarEncoding = string;
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    public void setJdkVersion(String string) {
        this.jdkVersion = string;
    }

    public void setBuildNodeFiles(Boolean bl) {
        this.buildNodeFiles = bl;
    }

    public void setMulti(Boolean bl) {
        this.multi = bl;
    }

    public void setNodeDefaultVoid(Boolean bl) {
        this.nodeDefaultVoid = bl;
    }

    public void setNodeClass(String string) {
        this.nodeClass = string;
    }

    public void setNodeFactory(String string) {
        this.nodeFactory = string;
    }

    public void setNodePackage(String string) {
        this.nodePackage = string;
    }

    public void setNodePrefix(String string) {
        this.nodePrefix = string;
    }

    public void setNodeScopeHook(Boolean bl) {
        this.nodeScopeHook = bl;
    }

    public void setNodeUsesParser(Boolean bl) {
        this.nodeUsesParser = bl;
    }

    public void setTrackTokens(Boolean bl) {
        this.trackTokens = bl;
    }

    public void setVisitor(Boolean bl) {
        this.visitor = bl;
    }

    public void setVisitorDataType(String string) {
        this.visitorDataType = string;
    }

    public void setVisitorReturnType(String string) {
        this.visitorReturnType = string;
    }

    public void setVisitorException(String string) {
        this.visitorException = string;
    }

    public void setJavaTemplateType(String string) {
        this.javaTemplateType = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ESuccess execute() throws Exception {
        String[] stringArray = this.generateArguments();
        if (this.outputDirectory != null && !this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        LOCK.lock();
        try {
            com.helger.pgcc.jjtree.JJTree jJTree = new com.helger.pgcc.jjtree.JJTree();
            ESuccess eSuccess = jJTree.main(stringArray);
            return eSuccess;
        }
        finally {
            LOCK.unlock();
        }
    }

    private String[] generateArguments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.grammarEncoding)) {
            arrayList.add("-GRAMMAR_ENCODING=" + this.grammarEncoding);
        }
        if (StringUtils.isNotEmpty((String)this.outputEncoding)) {
            arrayList.add("-OUTPUT_ENCODING=" + this.outputEncoding);
        }
        if (StringUtils.isNotEmpty((String)this.jdkVersion)) {
            arrayList.add("-JDK_VERSION=" + this.jdkVersion);
        }
        if (this.buildNodeFiles != null) {
            arrayList.add("-BUILD_NODE_FILES=" + this.buildNodeFiles);
        }
        if (this.multi != null) {
            arrayList.add("-MULTI=" + this.multi);
        }
        if (this.nodeDefaultVoid != null) {
            arrayList.add("-NODE_DEFAULT_VOID=" + this.nodeDefaultVoid);
        }
        if (StringUtils.isNotEmpty((String)this.nodeClass)) {
            arrayList.add("-NODE_CLASS=" + this.nodeClass);
        }
        if (StringUtils.isNotEmpty((String)this.nodeFactory)) {
            arrayList.add("-NODE_FACTORY=" + this.nodeFactory);
        }
        if (StringUtils.isNotEmpty((String)this.nodePackage)) {
            arrayList.add("-NODE_PACKAGE=" + this.nodePackage);
        }
        if (StringUtils.isNotEmpty((String)this.nodePrefix)) {
            arrayList.add("-NODE_PREFIX=" + this.nodePrefix);
        }
        if (this.nodeScopeHook != null) {
            arrayList.add("-NODE_SCOPE_HOOK=" + this.nodeScopeHook);
        }
        if (this.nodeUsesParser != null) {
            arrayList.add("-NODE_USES_PARSER=" + this.nodeUsesParser);
        }
        if (this.trackTokens != null) {
            arrayList.add("-TRACK_TOKENS=" + this.trackTokens);
        }
        if (this.visitor != null) {
            arrayList.add("-VISITOR=" + this.visitor);
        }
        if (StringUtils.isNotEmpty((String)this.visitorDataType)) {
            arrayList.add("-VISITOR_DATA_TYPE=" + this.visitorDataType);
        }
        if (StringUtils.isNotEmpty((String)this.visitorReturnType)) {
            arrayList.add("-VISITOR_RETURN_TYPE=" + this.visitorReturnType);
        }
        if (StringUtils.isNotEmpty((String)this.visitorException)) {
            arrayList.add("-VISITOR_EXCEPTION=" + this.visitorException);
        }
        if (this.outputDirectory != null) {
            arrayList.add("-OUTPUT_DIRECTORY=" + this.outputDirectory.getAbsolutePath());
        }
        if (StringUtils.isNotEmpty((String)this.javaTemplateType)) {
            arrayList.add("-JAVA_TEMPLATE_TYPE=" + this.javaTemplateType);
        }
        if (this.inputFile != null) {
            arrayList.add(this.inputFile.getAbsolutePath());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String toString() {
        return Arrays.asList(this.generateArguments()).toString();
    }
}

