/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjdoc;

import com.helger.pgcc.jjdoc.IDocGenerator;
import com.helger.pgcc.jjdoc.JJDoc;
import com.helger.pgcc.jjdoc.TextGenerator;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.CodeProductionCpp;
import com.helger.pgcc.parser.CodeProductionJava;
import com.helger.pgcc.parser.ExpNonTerminal;
import com.helger.pgcc.parser.ExpRCharacterList;
import com.helger.pgcc.parser.ExpRJustName;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.TokenProduction;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class BNFGenerator
implements IDocGenerator {
    private final Map<String, String> m_aIDMap = new HashMap<String, String>();
    private int m_nID = 1;
    protected Writer m_aPW;
    private boolean m_bPrinting = true;

    protected String get_id(String string2) {
        return this.m_aIDMap.computeIfAbsent(string2, string -> "prod" + this.m_nID++);
    }

    protected static Writer create_output_stream() {
        return TextGenerator.createPrintWriter(".bnf");
    }

    @Override
    public void text(String string) throws IOException {
        if (this.m_bPrinting && (string.length() != 1 || string.charAt(0) != '\n' && string.charAt(0) != '\r')) {
            this.print(string);
        }
    }

    @Override
    public void print(String string) throws IOException {
        this.m_aPW.write(string);
    }

    @Override
    public void documentStart() {
        this.m_aPW = BNFGenerator.create_output_stream();
    }

    @Override
    public void documentEnd() throws IOException {
        this.m_aPW.close();
    }

    @Override
    public void specialTokens(String string) {
    }

    @Override
    public void nonterminalsStart() {
    }

    @Override
    public void nonterminalsEnd() {
    }

    @Override
    public void tokensStart() {
    }

    @Override
    public void tokensEnd() {
    }

    @Override
    public void javacode(CodeProductionJava codeProductionJava) {
    }

    @Override
    public void cppcode(CodeProductionCpp codeProductionCpp) {
    }

    @Override
    public void expansionEnd(Expansion expansion, boolean bl) {
    }

    @Override
    public void nonTerminalStart(ExpNonTerminal expNonTerminal) {
    }

    @Override
    public void nonTerminalEnd(ExpNonTerminal expNonTerminal) {
    }

    @Override
    public void productionStart(NormalProduction normalProduction) throws IOException {
        this.print("\n");
        this.print(normalProduction.getLhs() + " ::= ");
    }

    @Override
    public void productionEnd(NormalProduction normalProduction) throws IOException {
        this.print("\n");
    }

    @Override
    public void expansionStart(Expansion expansion, boolean bl) throws IOException {
        if (!bl) {
            this.print(" | ");
        }
    }

    @Override
    public void reStart(AbstractExpRegularExpression abstractExpRegularExpression) {
        if (abstractExpRegularExpression.getClass().equals(ExpRJustName.class) || abstractExpRegularExpression.getClass().equals(ExpRCharacterList.class)) {
            this.m_bPrinting = false;
        }
    }

    @Override
    public void reEnd(AbstractExpRegularExpression abstractExpRegularExpression) {
        this.m_bPrinting = true;
    }

    @Override
    public void handleTokenProduction(TokenProduction tokenProduction) throws IOException {
        this.m_bPrinting = false;
        String string = JJDoc.getStandardTokenProductionText(tokenProduction);
        this.text(string);
        this.m_bPrinting = true;
    }
}

