/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.pgcc.parser.ExpLookahead;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ExpSequence
extends Expansion {
    final List<Expansion> m_units = new ArrayList<Expansion>();

    public ExpSequence() {
    }

    public ExpSequence(Token token, ExpLookahead expLookahead) {
        this.setLine(token.beginLine);
        this.setColumn(token.beginColumn);
        this.m_units.add(expLookahead);
    }

    public void addUnit(Expansion expansion) {
        this.m_units.add(expansion);
    }

    @Nonnull
    public Iterable<Expansion> units() {
        return this.m_units;
    }

    @Nonnegative
    public int getUnitCount() {
        return this.m_units.size();
    }

    @Override
    public StringBuilder dump(int n, Set<? super Expansion> set) {
        if (!set.add(this)) {
            return super.dump(0, set).insert(0, '[').append(']').insert(0, ExpSequence.dumpPrefix(n));
        }
        StringBuilder stringBuilder = super.dump(n, set);
        for (Expansion expansion : this.m_units) {
            stringBuilder.append(EOL).append((CharSequence)expansion.dump(n + 1, set));
        }
        return stringBuilder;
    }
}

